.TH mugs 1L "2 Jan 1990" "Local" "LOCAL COMMANDS"
.SH NAME
mugs \- multiple graphics in a single page
.SH SYNOPSIS
.I mugs
-x n_plots_x -y n_plots_y [-o out_file] [-r] [-t] [-p]
[-s] in_file1 {in_file2 | blank} ...
.SH DESCRIPTION
.I mugs
is a locally written utility, used to combine multiple PostScript graphics
into a single page.  The individual graphics can be generated by the
.I b\-spline(l)
or the
.I mindtool(l)
programs, and must be saved as PostScript files.  Up to 30 graphics can
be processed.
.SH INSTRUCTIONS
Execute
.I mugs
with no arguments for minimal, but useful instructions.
.SH FLAGS
.TP 8
-x
number of plots desired in the X\- direction (horizontal)
.TP
-y
number of plots desired in the Y\- direction (vertical)
.TP
-o
name of the PostScript output file to be produced.  If this flag is not
used, the output will be written to the standard output.
.TP
-s
the input files are, in that order, left and right views of a stereopair.
The figures will be adjusted to a separation between equivalent positions
of 6 cm (12 cm for double sized figures).  A typical command for a
viewing-sized stereo pair is
.I "mugs -x 4 -y 3 -r -s blank blank blank blank blank left right"
and for double-sized stereo pair use
.I 'mugs -x 2 -y 1 -r
.I -s left right' .
.TP
-r
remove all input files after finished.
.TP
-p
will change the orientation of a single input file from the default 
landscape to portrait.
.TP
-d      
Do not apped a <control-d> to the end of the file.  Also may be
configured in the Makefile
.TP
-n      
Do not change the scale of the plot when in portrait mode.
.TP
-t
will reduce the thickness of the lines proportionally to the scale of
the plots themselves.  The default setting preserves the original
thickness.
.SH NOTES
The
.I mugs
program accepts only up to 30 files as input.  Any excessive file is
simply ignored.  If the number of plots specified via the -x and -y
flags exceeds 30 the program will stop with a -1 status.  The
special keyword
.I blank
can be used in place of a file name as a spacer, i. e. it will leave a
blank space in the position where the corresponding file would have
been plotted.  The individual plots are placed in the order given in
the command line from left to right, and top to bottom.
.I mugs
can only process postcript files that use the graphics prologue includes
in this distribution.
.SH SEE ALSO
b-spline(l), mindtool(l)
.SH BUGS
Report any potential bugs or problems you find while using this utility to 
Julian Tirado-Rives (e-mail adress julian@doctor.chem.yale.edu).
.SH FILES

/usr/local/bin/mugs*
/usr/man/manl/mugs.l
/usr/local/src/graphics/mugs.c
