      subroutine line (x,y,n,k,j,ocsym)
      character strocs
      integer ocsym
      dimension x(1),y(1)
c
c   plot pairs x,y scaled to minimum of
c   x(n*k+1),y(n*k+1), and increment per inch
c   of x(n*(k+1)),y(n*(k+1)).
c
c   x = horizontal array of points
c   y = vertical array of points
c   n = # of pairs of points to ploit in x and y
c   k = plot n points from the 1st, k+1st, 2,k+1st, etc..
c       positions of arrays x and y.
c   j = >0: plot symbol ocsym (hollerith) each jth point
c            with connected line
c   j =  0: plot only the line.
c   j = <0: plot only the symbols each jth point.
c
c @(#)line.f	1.1  4/3/89 
c
      n1 = n*k
      im = n1+1
      id = im+k
      if (x(id).eq.0.or.y(id).eq.0) return
      ipen = 2
      m = j
      if (j.lt.0) then
         m = -m
         ipen = 3
      endif
      x1 = (x(1)-x(im))/x(id)
      y1 = (y(1)-y(im))/y(id)
      call plot (x1,y1,3)
      jcnt = 0
      do 10 i = 1, n1, k
         jcnt = jcnt+1
         xp = (x(i)-x(im))/x(id)
         yp = (y(i)-y(im))/y(id)
         if (j.ne.0) then
            if (m.ne.jcnt) go to 10
            jcnt = 0
         endif
         call plot (xp,yp,ipen)
         if (j.ne.0) then
            strocs = char(ocsym)
            call symbol (xp,yp,.14,strocs,0.,-1)
            call plot (xp,yp,3)
         endif
   10 continue
      return
      end
