      subroutine bound_box(coordxl,coordyl,label,angle)
c
c This routine will draw a bounded box and report back
c the lower left corner.
c
c James Blake
c @(#)bound_box.f	1.1  4/3/89 
c
      integer x,y,xlist(10),ylist(10),valid,choice
      integer ix(5), iy(5)
      integer llx,lly,ulx,uly,urx,ury,lrx,lry
      character*80 string
      character*(*) label
c
c Initialize the graphics input devices and numbers.
c
      x = screenx(coordxl)
      y = screeny(coordyl)
      call cfqtextext(label,' ',iconx,icony,
     &                llx,lly,ulx,uly,urx,ury) 
      lrx = urx + llx - ulx
      lry = ury + lly - uly
      call rotate(llx,lly,angle)
      call rotate(ulx,uly,angle)
      call rotate(urx,ury,angle)
      call rotate(lrx,lry,angle)
      call cfinitlid(0,1,x,y,xlist,ylist,n,val,choice,
     $               string,segid,pickid)
c
c Associate mouse buttons to the event and 
c enable tracing of the mouse position.
c
      call cfassoc(2,0,1)
      call cfassoc(5,0,1)
      call cftrackon(0,1,1,0,0,10000,10000,x,y,xlist,ylist,n,
     $               val,choice,string,segid,pickid)
c     
c set a good color and XOR drawing mode.
c
      call newpen(3)
      call cfsgldrawmode(4)
c
      dx = x - urx
      dy = y - ury
c
      ix(1) = urx + dx 
      iy(1) = ury + dy 
c
      ix(2) = ulx + dx 
      iy(2) = uly + dy 
c
      ix(3) = llx + dx 
      iy(3) = lly + dy 
c
      ix(4) = lrx + dx 
      iy(4) = lry + dy 
c      
      ix(5) = ix(1) 
      iy(5) = iy(1) 
      call cfpolyline(ix,iy,5)
      valid = 0
      itrig = 0
c
c Loop while the user is moving the mouse.
c
      do while (valid .eq. 0 .and. itrig .ne. 2)
         call cfreqinp(0,1,-1,valid,itrig,x,y,xlist,ylist,n,
     $                 val,choice,string,segid,itrig,pickid)
c
         call cfpolyline(ix,iy,5)
      dx = x - urx
      dy = y - ury
      ix(1) = urx + dx 
      iy(1) = ury + dy 
c
      ix(2) = ulx + dx 
      iy(2) = uly + dy 
c
      ix(3) = llx + dx 
      iy(3) = lly + dy 
c
      ix(4) = lrx + dx 
      iy(4) = lry + dy 
c      
      ix(5) = ix(1) 
      iy(5) = iy(1) 
         call cfpolyline(ix,iy,5)
      enddo
c
c Dissociate the buttons and release the device.
c
      call cfpolyline(ix,iy,5)
      call cfsgldrawmode(0)
      call cftrackoff(0,1,0,0)
      call cfdissoc(2,0,1)
      call cfdissoc(5,0,1)
      call cfrelidev(0,1)
      coordxl = page_x(ix(3)) 
      coordyl = page_y(iy(3)) 
      call newpen(1)
      return
      end
c
c
      subroutine rotate(x,y,theta)
      integer x,y
c
      xt = x
      yt = y
c
      x = xt*cosd(theta) - yt*sind(theta)
      y = xt*sind(theta) + yt*cosd(theta)
      return
      end
