      subroutine draw_arc(x1,y1,x3,y3,cx,cy,r)
c
c
c James Blake
c @(#)arcs.f	1.1  4/3/89
c
      include 'device_type.h'
      common /tscale/ sfactt
      common /cqpbnf/ xold, yold, fac, ires
c
      
      if(color_ws .or. mono_ws) then
         ix1 = screenx(x1)
         iy1 = screeny(y1)
         ix3 = screenx(x3)
         iy3 = screeny(y3)
         icx = screenx(cx)
         icy = screeny(cy)
         ir  = int(3276.7 * r * sfactt)
         call cfcircarccent(icx,icy,ix1,iy1,ix3,iy3,ir)
      elseif (PostScript) then
         PI = 3.141592654 
         call plsout("newpath ")
C
C put out the origin and radius
C
         call pliout (nint (cx*fac*ires))
         call plcout (char(32))
         call pliout (nint (cy*fac*ires))
         call plcout (char(32))
         call pliout (nint (r*fac*ires))
         call plcout (char(32))
C
C
	 angle1 = atan2(y1-cy, x1-cx) * 180.0 / PI
	 angle2 = atan2(y3-cy, x3-cx) * 180.0 / PI
         call pliout (nint (angle1))
         call plcout (char(32))
         call pliout (nint (angle2))
         call plcout (char(32))
c
         call plsout ("arc stroke\n")
      endif
      return
      end
c
c
      subroutine gen_arc(x1,y1,x2,y2,x3,y3,cx,cy,r)
c
c James Blake
c 11/88
c
      integer x,y,xlist(10),ylist(10),valid,choice
      integer ix(3), iy(3), arc_direction
      character*80 string
      common /tscale/ sfactt
c
c
c Initialize the graphics input devices and numbers.
c
      call gen_line(x1,y1,x3,y3)
      ix(1) = screenx(x1)
      iy(1) = screeny(y1)
      xmid  = abs(x1 - x3) / 2.0 + min(x1,x3)
      ymid  = abs(y1 - y3) / 2.0 + min(y1,y3)
      ix(2) = screenx(xmid)
      iy(2) = screeny(ymid)
      ix(3) = screenx(x3)
      iy(3) = screeny(y3)
      x = ix(2)
      y = iy(2)
      call cfinitlid(0,1,x,y,xlist,ylist,n,val,choice,
     $               string,segid,pickid)
c
c Associate mouse buttons to the event.
c
      call cfassoc(2,0,1)
      call cftrackon(0,1,1,0,0,10000,10000,x,y,xlist,ylist,n,
     $               val,choice,string,segid,pickid)
c     
c Enable tracing of the mouse position.
c
      call cfassoc(5,0,1)
c
c set a good color and XOR drawing mode.
c
      call newpen(3)
      call cfsgldrawmode(4)
c
      valid = 0
      itrig = 0
c
c Loop while the user is moving the mouse.
c
      call cfpolyline(ix,iy,3)
      do while (valid .eq. 0 .and. itrig .ne. 2)
         call cfreqinp(0,1,-1,valid,itrig,x,y,xlist,ylist,n,
     $                 val,choice,string,segid,itrig,pickid)
c
         call cfpolyline(ix,iy,3)
         ix(2) = x 
         iy(2) = y
         call cfpolyline(ix,iy,3)
      enddo
c
c Dissociate the buttons and release the device.
c
      call cfpolyline(ix,iy,3)
      call cfsgldrawmode(0)
      call cfdissoc(2,0,1)
      call cfdissoc(5,0,1)
      call cfrelidev(0,1)
      call newpen(1)
      x1 = float(ix(1)) 
      y1 = float(iy(1))
      x2 = float(ix(2))
      y2 = float(iy(2))
      x3 = float(ix(3))
      y3 = float(iy(3))
      idir = arc_direction(x1,y1,x2,y2,x3,y3)
      call arc_center(x1,y1,x2,y2,x3,y3,cx,cy,r)
      icx = int(cx)
      icy = int(cy)
      if (idir .eq. 1) then
         x1 = page_x(ix(1))
         y1 = page_y(iy(1))
         x3 = page_x(ix(3))
         y3 = page_y(iy(3))
      else
         x1 = page_x(ix(3))
         y1 = page_y(iy(3))
         x3 = page_x(ix(1))
         y3 = page_y(iy(1))
      endif
      cx = page_x(icx)
      cy = page_y(icy)
      x2 = page_x(ix(2))
      y2 = page_y(iy(2))
      r  = r / (3276.7 * sfactt)
      return
      end
C
      integer function arc_direction(x1,y1,x2,y2,x3,y3)
c
c 1 if direction 1 -> 2 -> 3 is counterclockwise, 
c 0 otherwise.
c
      PI = 3.141592654 
      dx = x2 - x1
      dy = y2 - y1
      alpha = vec_angle(dx,dy)
c
      dx = x3 - x2
      dy = y3 - y2
      theta = vec_angle(dx,dy)
c
      diff = theta - alpha
      if (( diff .gt. 0.0 .and. diff .lt. PI) .or. diff .lt. -PI) then
         arc_direction = 1
      else
         arc_direction = 0
      endif
      return
      end
c
c
      real function vec_angle(dx,dy)
c
      PI = 3.141592654 
      if(dx .eq. 0.0) then
         if(dy .gt. 0.0) then
            vec_angle = PI / 2.0
         else
            vec_angle = 3.0 * PI / 2.0
         endif
      elseif(dy .eq. 0.0) then
         if(dx .gt. 0.0) then
            vec_angle = 0.0
         else
            vec_angle = PI
         endif
      else
         vec_angle = atan(dy/dx)
         if(dx .lt. 0.0) then
            vec_angle = vec_angle + PI
         elseif(dy .lt. 0.0) then
            vec_angle = vec_angle + 2.0 * PI
         endif
      endif
      return
      end
c
c
      subroutine arc_center(x1,y1,x2,y2,x3,y3,cx,cy,r)
c
      dx12 = x1 - x2
      dy12 = y1 - y2
      dx13 = x1 - x3
      dy13 = y1 - y3
c
      s12 = asin((dy12 / sqrt((dx12*dx12 + dy12*dy12))))
      s13 = asin((dy13 / sqrt((dx13*dx13 + dy13*dy13))))
c
      dl1 = x1**2 + y1**2
      dl2 = x2**2 + y2**2
      dl3 = x3**2 + y3**2
c
      cy = (dx12 * (dl3 - dl1) - dx13 * (dl2 - dl1)) /
     &     (2.0 * (dx13 * dy12 - dx12 * dy13))
      if (dx13 .ne. 0.0) then
          cx = (dl3 + 2.0 * cy * dy13 - dl1) / (2.0 * (-dx13))
      else
          cx = (dl2 + 2.0 * cy * dy12 - dl1) / (2.0 * (-dx12))
      endif
      dx = x1 - cx
      dy = y1 - cy
      r = sqrt(dx**2 + dy**2)
      return
      end
