c-----------------------------------------------------------------------
      subroutine rtsf(x, nd, rtf)
c-----------------------------------------------------------------------
c
c     Will generate the F-format necessary to read a real number into
c     a string.
c     
c     input : X, a real single-precision number
c             ND, the number of digits after the decimal point
c        
c     output : RTF, a character*8 string that contains the format.
c
c     IF IS LIMITED TO NUMBERS WITHIN E+99 TO E-99.
c     
      character str1*2, str2*2
      character rtf*8
      real x
c
      nbp = int(log10(abs(x))) + 1
      if (x .lt. 0.) nbp = nbp + 1
      nt = (nbp + 1) + nd
      write(unit=str1, fmt='(I2)') nt
      write(unit=str2, fmt='(I2)') nd
      if (nt .gt. 9) then
         if (nd .ge. 10) then
            rtf = ((('(F' // str1(1:2)) // '.') // str2(1:2)) // ')'
         else
            rtf = ((('(F' // str1(1:2)) // '.') // str2(2:2)) // ')'
         end if
      else
         rtf = ((('(F' // str1(2:2)) // '.') // str2(2:2)) // ')'
      end if
      if (nt .gt. 10) rtf = 'E10.4'
      return 
      end
