c-----------------------------------------------------------------------
      subroutine lineanal(line, place, fmtstr, form, nstring)
c-----------------------------------------------------------------------
c     
c     This subroutine takes an input character string ("LINE"), and
c     partitions it in its natural segements as separated by blanks.
c     The string itself is the only necessary input, and its length 
c     is determined when called. It returns the line itself, the
c     integer array "PLACE" which contains the positions of the
c     first and last non-blank characters of each segment, a character
c     string "FORM" which contains a one-letter descriptor of the
c     data type of each segment (A, I, or F) and "FMTSTR", a character
c     array containing the string-formats for each segment. The only
c     variables limited in its length are FMSTR (10 characters for
c     each individual format) and "STRING", a temporary storage for
c     each individual segment (80 char's).
c
      character line*(*), form*(*)
      character string*80
      character fmtstr*10
      character typ*1
      logical found, num, firstchar, decpoint, exponent
      integer iline, istring, nstring, eol, is, ie, ici, place
c
      dimension place(2), fmtstr(2)
c
      call limits(line, iline, eol)
      nstring = 0
  100 if (iline .le. eol) then
         string = ' '
         istring = 1
         found = .false.
         typ = ' '
  200    if (line(iline:iline) .ne. ' ') then
            firstchar = .false.
            num = .false.
            found = .true.
            string(istring:istring) = line(iline:iline)
            if (typ .eq. ' ') then
               place((2 * nstring) + 1) = iline
               exponent = .false.
               decpoint = .false.
               firstchar = .true.
               ici = ichar(line(iline:iline))
               if (ici .eq. 46) decpoint = .true.
               num = (ici .le. 57) .and. (((ici .ge. 48) .or. 
     &                (ici .eq. 43)) .or. (ici .eq. 45))
               if (num) then
                  typ = 'I'
               else
                  typ = 'A'
               end if
               if ((typ .eq. 'A') .and. decpoint) typ = 'F'
            end if
c
            if ((typ .ne. 'A') .and. (.not. firstchar)) then
                 ici = ichar(line(iline:iline))
                 num = (ici .le. 57) .and. (ici .ge. 48)
                 if ((typ .eq. 'I') .and. num) goto 300
c
                 if ((typ .eq. 'F') .and. num) goto 300
                 if (ici .eq. 46) then
                 if (typ .eq. 'I') then
                    decpoint = .true.
                    typ = 'F'
                    goto 300
                 else
                    if (decpoint) typ = 'A'
                 end if
              end if
c
              if ((((ici.eq.69) .or. (ici.eq.68)) .or. (ici.eq.101))
     &                  .or. (ici .eq. 100)) then
                 if (.not. exponent) then
                    typ = 'F'
                    exponent = .true.
                    icn = ichar(line(iline + 1:iline + 1))
                    nxt = ((icn .eq. 43) .or. (icn .eq. 45)) .or.
     &                     ((icn .ge. 48) .and. (icn .le. 57))
                    if (nxt) then
                       istring = istring + 1
                       iline = iline + 1
                       string(istring:istring) = line(iline:iline)
                       goto 300
                    else
                       typ = 'A'
                    end if
                 else
                    typ = 'A'
                 end if
              end if
           typ = 'A'
        end if
c
  300    iline = iline + 1
         istring = istring + 1
         goto 200
      end if
      if (found) then
           place((2 * nstring) + 2) = iline - 1
           is = place((2 * nstring) + 1)
           ie = place((2 * nstring) + 2)
           nstring = nstring + 1
           form(nstring:nstring) = typ
           call findformat(line(is:ie), is, ie, form(nstring:nstring), 
     &                     fmtstr(nstring))
      end if
      iline = iline + 1
      goto 100
      end if
      return 
      end
