*     **************************
      FUNCTION TEXTUR(NQ,TEXDER)
*     **************************
      REAL TEXDER(1)
*
*************************************************************************
*   The theory of texture corrections was developed by Matti Jarvinen,  *
*   Lappeenranta University of Technology, Lappeenranta, FINLAND.       *
*************************************************************************
*
      INTEGER ORDER(15,13)
      INCLUDE 'BLANK.FOR'
      COMMON/PARAMS/AINSTR(10),ACRYST(22), ATOM(14,30),
     *              LINSTR(10),LCRYST(22),LATOM(14,30),
     *              PINSTR(10),PCRYST(22),PATOM(14,30)
      COMMON/SPACE/JUMP,A,B,C,COSALF,COSBET,COSGAM,SINALF,SINBET,SINGAM
*
      DATA ORDER/
*
*   JUMP               Indices of Y
     1     +20,+21,-21,+22,-22,+40,+41,-41,+42,-42,+43,-43,+44,-44,  0,
     2     +20,+22,-22,+40,+42,-42,+44,-44,+60,+62,-62,+64,-64,+66,-66,
     3     +20,+22,+40,+42,+44,+60,+62,+64,+66,  0,  0,  0,  0,  0,  0,
     4     +20,+22,+40,+42,+44,+60,+62,+64,+66,  0,  0,  0,  0,  0,  0,
     5     +20,+22,+40,+42,+44,+60,+62,+64,+66,  0,  0,  0,  0,  0,  0,
     6     +20,+40,+44,-44,+60,+64,-64,  0,  0,  0,  0,  0,  0,  0,  0,
     7     +20,+40,+44,+60,+64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     8     +20,+40,+43,-43,+60,+63,-63,+66,-66,  0,  0,  0,  0,  0,  0,
     9     +20,+40,+43,+60,+63,+66,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     A     +20,+40,+60,+66,-66,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     B     +20,+40,+60,+66,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     C     +40,+61,+62,+81,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     D     +40,+61,+81,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
*
      DO 10 I=1,15
*
*     Pick up indices lms for spherical harmonic functions
*     and branch out when l=0 is encountered.
*
      L=ABS(ORDER(I,JUMP)/10)
      IF(L .EQ. 0) GO TO 20
      M=MOD(ORDER(I,JUMP),10)
*                             Spherical harmonic functions come from Y
      IF(JUMP .LT. 12) THEN
         TEXDER(I)=Y(L,0,GEOM(NQ),0.0)*Y(L,M,COSTHE(NQ),COSPHI(NQ))
*
*                             Cubic harmonic functions come from CUBHAR
      ELSE
         TEXDER(I)=Y(L,0,GEOM(NQ),0.0)*CUBHAR(L,M,COSTHE(NQ),COSPHI(NQ))
      END IF
   10 CONTINUE
*
*     Texture correction coefficient is a sum of products
*     parameter x (spherical harmonic function).
*
   20 T=1
      DO 30 M=1,I-1
      T=T+TEXDER(M)*PCRYST(M+7)
   30 CONTINUE
      TEXTUR=T
      RETURN
      END
