*     ************************
      SUBROUTINE RADIAT(XRAYS)
*     ************************
*
*     This subroutine reads the incident angle and radiation type
*     and checks for their validity.
*
      LOGICAL XRAYS
*
      CHARACTER RAYS*1,SOURCE*7
      REAL FLAG(1)
      INTEGER IFLAG(1)
      INCLUDE 'BLANK.FOR'
      COMMON/DATA/CUT,NREFL,NH(3),IALFA,ISTAP,NCHAN,ICODE(999),
     *       HKL(999,3),SJJ(999),YOBS(15000),WEIGHT(15000),IORD(15000,2)
      DATA CONST/11459.155903/,RAD/1.7453292520E-2/
*
      CALL READER(RAYS,0,FLAG,1,IFLAG,0,.FALSE.)
      CALL READER(RAYS,1,FLAG,0,IFLAG,0,.FALSE.)
      IF(ABS(FLAG(1)).GT.90) THEN
         WRITE(6,1000) FLAG(1)
         FLAG(1)=0
      END IF
      IF(RAYS.EQ.'X'.OR.RAYS.EQ.'x') THEN
         XRAYS=.TRUE.
         SOURCE='X - ray'
      ELSE IF(RAYS.EQ.'N'.OR.RAYS.EQ.'n') THEN
         XRAYS=.FALSE.
         SOURCE='Neutron'
      ELSE
         WRITE(6,1001)
         STOP
      END IF
      WRITE(6,1002) SOURCE,FLAG(1)
      DO 10 I=1,NREFL
*                                  Reflection geometry     - alpha =  0
      IF(FLAG(1).EQ.0) THEN
         GEOM(I)=1
*                                  Transmission geometry and
*                                  Debye-Scherrer geometry - alpha = 90
      ELSE IF(FLAG(1).EQ.90) THEN
         GEOM(I)=0
*                                  Guinier geometries -
*                                  alpha = theta - incident angle
      ELSE
         GEOM(I)=COS(BRAGG(I)/CONST+RAD*FLAG(1))
      END IF
   10 CONTINUE
      RETURN
 1000 FORMAT(' Invalid incident angle =',F6.1,'. Zero assumed.')
 1001 FORMAT(' No radiation specified. Give a word starting with',
     *       ' X for X-rays or N for neutrons on line 2.')
 1002 FORMAT(/,1X,A,' radiation is used with incident angle',F6.1,
     *       ' degrees.',/)
      END
