*     **************************
      SUBROUTINE PICK(I,J,A,L,P)
*     **************************
*
*     This subroutine picks the correct combination of parameters and
*     parameter-related items. Dummy argument 'I' specifies the
*     parameter type or group according to the following table.
*     Then 'J' picks the desired position in the arrays chosen.
*
*     -----------------------------------------
*         I      Parameter group     Range of J
*     -----------------------------------------
*         1      Instrument            1 ... 10
*         2      Crystal               1 ... 22
*         3      Atom 1                1 ... 14
*         4      Atom 2                1 ... 14
*         5      Atom 3                1 ... 14
*         .        .                      .
*         .        .                      .
*         .        .                      .
*     -----------------------------------------
      COMMON/PARAMS/AINSTR(10),ACRYST(22), ATOM(14,30),
     *              LINSTR(10),LCRYST(22),LATOM(14,30),
     *              PINSTR(10),PCRYST(22),PATOM(14,30)
*
      IF(I.EQ.1) THEN
         IF(J.LE.0.OR.J.GT.10) GO TO 10
         A=AINSTR(J)
         L=LINSTR(J)
         P=PINSTR(J)
      ELSE IF(I.EQ.2) THEN
         IF(J.LE.0.OR.J.GT.22) GO TO 10
         A=ACRYST(J)
         L=LCRYST(J)
         P=PCRYST(J)
      ELSE
         IF(J.LE.0.OR.J.GT.14) GO TO 10
         A= ATOM(I-2,J)
         L=LATOM(I-2,J)
         P=PATOM(I-2,J)
      END IF
      IF(L.GT.0) RETURN
*
*     L cannot be zero because it is used as an array index in CONPRE.
*     J must also be inside specified range.
*
   10 WRITE(6,1000) I,J,L
      STOP
 1000 FORMAT(' In PICK: I, J and L are:',3I4,'. Something is wrong',
     *       ' in constraint function input.')
      END
