*     *****************************
      SUBROUTINE GROUP(ANGLE,XRAYS)
*     *****************************
*
      REAL ANGLE
      LOGICAL XRAYS
*
*     This subroutine reads the space group number (and for
*     orthorhombic case, the unique axis specification) and
*     chooses spherical harmonic functions affecting in
*     specified symmetry case.
*     The incident angle defining measurement geometry is read and
*     the radiation is specified.
*
      CHARACTER AXIS*1,TEXT*3,RAYS*1,SOURCE*7
      REAL FLAG(1)
      INTEGER IFLAG(1)
      COMMON/SPACE/JUMP,A,B,C,COSALF,COSBET,COSGAM,SINALF,SINBET,SINGAM
*
*     Take three non-blank characters from the next input line.
*
      AXIS=' '
      CALL READER(5,TEXT,3,FLAG,0,IFLAG,0,.TRUE.)
*
*     Is it a pure number?
*
      READ(TEXT,'(BN,I3)',ERR=10) IGROUP
*
*     Yes, it is.
*
      IF(IGROUP .LE. 0 .OR. IGROUP .GT. 230) GO TO 30
*
*                                    Triclinic
      IF(IGROUP .LE. 2) THEN
         JUMP=1
         WRITE(6,1000) 'triclinic',IGROUP
*                                    Monoclinic
      ELSE IF(IGROUP .LE.  15) THEN
         JUMP=2
         WRITE(6,1000) 'monoclinic',IGROUP
*
*     Orthorhombic case but unique axis choise was not given.
*     JUMP cannot be set.
*
      ELSE IF(IGROUP .LE.  74) THEN
      GO TO 40
*                                    Tetragonal case 1
      ELSE IF(IGROUP .LE.  88) THEN
         JUMP=6
         WRITE(6,1000) 'tetragonal',IGROUP
*                                    Tetragonal case 2
      ELSE IF(IGROUP .LE. 142) THEN
         JUMP=7
         WRITE(6,1000) 'tetragonal',IGROUP
*                                    Trigonal case 1
      ELSE IF(IGROUP .LE. 148) THEN
         JUMP=8
         WRITE(6,1000) 'trigonal',IGROUP
*                                    Trigonal case 2
      ELSE IF(IGROUP .LE. 167) THEN
         JUMP=9
         WRITE(6,1000) 'trigonal',IGROUP
*                                    Hexagonal case 1
      ELSE IF(IGROUP .LE. 176) THEN
         JUMP=10
         WRITE(6,1000) 'hexagonal',IGROUP
*                                    Hexagonal case 2
      ELSE IF(IGROUP .LE. 194) THEN
         JUMP=11
         WRITE(6,1000) 'hexagonal',IGROUP
*                                    Cubic case 1
      ELSE IF(IGROUP .LE. 206) THEN
         JUMP=12
         WRITE(6,1000) 'cubic',IGROUP
*                                    Cubic case 2
      ELSE
         JUMP=13
         WRITE(6,1000) 'cubic',IGROUP
      END IF
*
      GO TO 20
*
*     It is not a pure number - find unique axis specification.
*
   10 READ(TEXT,'(I2,A1)',ERR=40) IGROUP,AXIS
      IF(IGROUP .LT. 16 .OR. IGROUP .GT. 74) GO TO 40
*
*     Orthorombic space group found.
*     Is the character A, B or C?
*
      I  =  INDEX(AXIS,'A') + INDEX(AXIS,'a')
     * + 2*(INDEX(AXIS,'B') + INDEX(AXIS,'b'))
     * + 3*(INDEX(AXIS,'C') + INDEX(AXIS,'c'))
      IF(I .EQ. 0) GO TO 40
*
*     It is.
*
      JUMP=I+2
      WRITE(6,1001) IGROUP,AXIS
*
*     Now incident angle and radiation type.
*
   20 CALL READER(5,RAYS,0,FLAG,1,IFLAG,0,.FALSE.)
      CALL READER(5,RAYS,1,FLAG,0,IFLAG,0,.FALSE.)
      ANGLE=FLAG(1)
      IF(ABS(ANGLE) .GT. 90) THEN
         WRITE(6,1002) ANGLE
         ANGLE=0
      END IF
      IF(RAYS.EQ.'X'.OR.RAYS.EQ.'x') THEN
         XRAYS=.TRUE.
         SOURCE='X - ray'
      ELSE IF(RAYS.EQ.'N'.OR.RAYS.EQ.'n') THEN
         XRAYS=.FALSE.
         SOURCE='Neutron'
      ELSE
         WRITE(6,1003)
         STOP
      END IF
      WRITE(6,1004) SOURCE,ANGLE

      RETURN
*                               Error: Space group beyond limit.
   30 WRITE(6,1005) IGROUP
      GO TO 50
*                               Error: Incorrect information was given
*                                      for orthorombic case.
   40 WRITE(6,1006) IGROUP,AXIS
   50 STOP
 1000 FORMAT('0The symmetry is ',A,'. Space group =',I4,'.',/)
 1001 FORMAT('0The symmetry is orthorhombic. Space group =',I4,
     *       '. Unique axis = ',A1,'.',/)
 1002 FORMAT(' Invalid incident angle =',F6.1,'. Zero assumed.')
 1003 FORMAT(' No radiation specified. Give a word starting with',
     *       ' X for X-rays or N for neutrons on line 2.')
 1004 FORMAT(/,1X,A,' radiation is used with incident angle',F6.1,
     *       ' degrees.',/)
 1005 FORMAT(' In GROUP: Space group',I5,' is beyond limits.')
 1006 FORMAT(' In GROUP: Space group for orthorhombic case =',I4,
     *       '. Unique axis = ',A1,'. Either of them is invalid.')
      END
