*     ************************
      SUBROUTINE GEOMET(ANGLE)
*     ************************
      REAL ANGLE
*
*     This subroutine uses the incident angle to scale the texture
*     coefficients to be independent on measurement geometry.
*
      INCLUDE 'BLANK.FOR'
      COMMON/DATA/CUT,NREFL,NH(3),IALFA,ISTAP,NCHAN,ICODE(999),
     *       HKL(3,999),SJJ(999),YOBS(15000),WEIGHT(15000),IORD(15000)
      DATA CONST/11459.155903/,RAD/1.7453292520E-2/
*
      DO 10 I=1,NREFL
*                                  Reflection geometry     - alpha =  0
      IF(ANGLE .EQ. 0) THEN
         GEOM(I)=1
*                                  Transmission geometry and
*                                  Debye-Scherrer geometry - alpha = 90
      ELSE IF(ANGLE .EQ. 90) THEN
         GEOM(I)=0
*                                  Guinier geometries -
*                                  alpha = theta - incident angle
      ELSE
         GEOM(I)=COS(BRAGG(I)/CONST+RAD*ANGLE)
      END IF
   10 CONTINUE
      RETURN
      END
