*     ******************
      FUNCTION DTSLIN(L)
*     ******************
*
*     DTSLIN solves the matrix equation SMM*X=V for X and stores the
*     result X in V. The size of the system is L, where L.LE.51.
*
      REAL Q(51),U(51)
      INTEGER M(51)
      INCLUDE 'BLANK.FOR'
      SAVE
*
      DO 20 I=1,L
      Z=0
      DO 10 J=1,L
      D=1.0E-8*SMM(I,J)
   10 Z=D*D+Z
      Q(I)=SQRT(1.0E8*Z)
   20 U(I)=Q(I)
      DO 40 I=1,L
      Z=1/U(I)
      DO 30 J=1,L
   30 SMM(J,I)=SMM(J,I)*Z
   40 CONTINUE
      E=0
      DO 90 K=1,L
      R=-1
      DO 60 I=K,L
      Z=0
      DO 50 J=1,K-1
      Z=SMM(I,J)*SMM(J,K)+Z
   50 CONTINUE
      SMM(I,K)=SMM(I,K)-Z
      S=ABS(SMM(I,K)/Q(I))
      IF(S.GT.R) THEN
         R=S
         M(K)=I
      END IF
   60 CONTINUE
      KP=M(K)
      Q(KP)=Q(K)
      DO 80 J=1,L
      R=SMM(K,J)
      IF(J.LE.K) THEN
         KP=M(K)
         SMM(K,J)=SMM(KP,J)
      ELSE
         Z=0
         DO 70 I=1,K-1
         Z=SMM(K,I)*SMM(I,J)+Z
   70    CONTINUE
         KP=M(K)
         SMM(K,J)=(SMM(KP,J)-Z)/SMM(K,K)
      END IF
      KP=M(K)
      IF(KP.NE.K) SMM(KP,J)=-R
   80 CONTINUE
      E=E+ALOG10(ABS(SMM(K,K)))
   90 CONTINUE
      DTSLIN=E
      DO 110 K=1,L
      R=V(K)
      Z=0
      DO 100 I=1,K-1
      Z=SMM(K,I)*V(I)+Z
  100 CONTINUE
      KP=M(K)
      V(K)=(V(KP)-Z)/SMM(K,K)
      IF(KP.NE.K) V(KP)=-R
  110 CONTINUE
      DO 130 K=L,1,-1
      Z=0
      DO 120 I=K+1,L
      Z=SMM(K,I)*V(I)+Z
  120 CONTINUE
      V(K)=V(K)-Z
  130 CONTINUE
      DO 190 K=L,1,-1
      DO 140 J=K+1,L
      Q(J)=SMM(K,J)
      SMM(K,J)=0
  140 CONTINUE
      SMM(K,K)=1/SMM(K,K)
      DO 160 J=K-1,1,-1
      Z=0
      DO 150 I=J+1,K
      Z=SMM(K,I)*SMM(I,J)+Z
  150 CONTINUE
      SMM(K,J)=-Z/SMM(J,J)
  160 CONTINUE
      DO 180 J=1,L
      Z=0
      DO 170 I=K+1,L
      Z=Q(I)*SMM(I,J)+Z
  170 CONTINUE
      SMM(K,J)=SMM(K,J)-Z
  180 CONTINUE
  190 CONTINUE
      DO 210 K=L,1,-1
      IF(M(K).EQ.K) GO TO 210
      DO 200 I=1,L
      R=SMM(I,K)
      KP=M(K)
      SMM(I,K)=-SMM(I,KP)
      SMM(I,KP)=R
  200 CONTINUE
  210 CONTINUE
      DO 230 I=1,L
      V(I)=V(I)/U(I)
      DO 220 J=1,L
      SMM(I,J)=SMM(I,J)/U(I)
  220 CONTINUE
  230 CONTINUE
      RETURN
      END
