*     *********************
      SUBROUTINE DIRECT(SZ)
*     *********************
*
*     This subroutine prints and calculates the direct cell dimensions
*     and their E.S.D. from the cell constants and their E.S.D.
*
      CHARACTER ATEXT*4,TEXT*80
      REAL SZ(6,30)
      REAL SQ(6,6),DRV(6),SA(6),SSA(6),BIJ(6),SBIJ(6),FAK(6)
      INCLUDE 'BLANK.FOR'
      COMMON/CHARS/ATEXT(30),TEXT
      COMMON/PARAMS/AINSTR(10),ACRYST(22), ATOM(14,30),
     *              LINSTR(10),LCRYST(22),LATOM(14,30),
     *              PINSTR(10),PCRYST(22),PATOM(14,30)
      SAVE
      DATA RAD/1.745329252E-2/
*
      DO 10 J=1,6
      K=LCRYST(J)
      X=ACRYST(J)
      IF(K.EQ.0) X=0
      DO 10 L=J,6
      M=LCRYST(L)
      SQ(L,J)=0
      IF(M*K.NE.0) SQ(L,J)=SMM(M,K)*X*ACRYST(L)
   10 SQ(J,L)=SQ(L,J)
      VOLUME=PCRYST(1)*PCRYST(2)*PCRYST(3)+
     *       PCRYST(4)*PCRYST(5)*PCRYST(6)/4
      DO 20 I=1,3
      VOLUME=VOLUME-PCRYST(I)*PCRYST(I+3)**2/4
      J=MOD(I,3)+1
      K=MOD(I+1,3)+1
      DRV(I)=PCRYST(J)*PCRYST(K)-PCRYST(I+3)**2/4
   20 DRV(I+3)=(PCRYST(J+3)*PCRYST(K+3)-2*PCRYST(I)*PCRYST(I+3))/4
      SVOL=0
      DO 30 I=1,6
      DO 30 J=I,6
      X=1
      IF(I.NE.J) X=2
   30 SVOL=SVOL+SQ(I,J)*DRV(I)*DRV(J)*X
      DO 60 I=1,3
      DO 40 J=1,6
   40 DRV(J)=0
      J=MOD(I,3)+1
      K=MOD(I+1,3)+1
      SA(I)=SQRT(PCRYST(I))
      SA(I+3)=PCRYST(I+3)/(2*SQRT(PCRYST(J)*PCRYST(K)))
      SSA(I)=SQ(I,I)/(4*PCRYST(I))
      DRV(I+3)=1/(2*SQRT(PCRYST(J)*PCRYST(K)))
      DRV(J)=-PCRYST(K)*PCRYST(I+3)/(4*(PCRYST(J)*PCRYST(K))**1.5)
      DRV(K)=-PCRYST(J)*PCRYST(I+3)/(4*(PCRYST(J)*PCRYST(K))**1.5)
      SSA(I+3)=0
      DO 50 J=1,6
      DO 50 K=J,6
      X=1
      IF(J.NE.K) X=2
   50 SSA(I+3)=SSA(I+3)+SQ(J,K)*DRV(J)*DRV(K)*X
      SSA(I+3)=SSA(I+3)/((1-SA(I+3)**2)*RAD**2)
      IF(SA(I+3).NE.0) THEN
         SA(I+3)=ATAN(SQRT(1-SA(I+3)**2)/SA(I+3))/RAD
      ELSE
         SA(I+3)=90
      END IF
      IF(PCRYST(I+3).EQ.0) SA(I+3)=90
      IF(SQ(I+3,I+3).EQ.0) SSA(I+3)=0
   60 CONTINUE
      DO 70 I=1,6
      IF(SSA(I).LT.0) SSA(I)=0
   70 CONTINUE
      CALL ESD(SQ,PCRYST)
      WRITE(6,1000)
      DO 80 I=1,3
      I1=10000*SQ(I,I)+0.5
      I2=1000*SQ(I+3,I+3)+0.5
      I3=1000000*SQRT(SSA(I))+0.5
      I4=1000*SQRT(SSA(I+3))+0.5
   80 WRITE(6,1001) PCRYST(I),I1,PCRYST(I+3),I2,SA(I),I3,SA(I+3),I4
      X1=1/SQRT(VOLUME)
      I2=100*SQRT(SVOL/(4*VOLUME**3))+0.5
      X3=SQRT(VOLUME)
      I4=10000000*SQRT(SVOL/(4*VOLUME))+0.5
      WRITE(6,1002) X1,I2,X3,I4
      WRITE(6,1003)
      FAK(1)=4/(SA(1)*SA(1))
      FAK(2)=4/(SA(2)*SA(2))
      FAK(3)=4/(SA(3)*SA(3))
      FAK(4)=4/(SA(1)*SA(2))
      FAK(5)=4/(SA(1)*SA(3))
      FAK(6)=4/(SA(2)*SA(3))
      DO 100 I=1,N
      DO 90 J=1,6
      BIJ (J)=PATOM(J+8,I)*FAK(J)
   90 SBIJ(J)=SZ(J,I)*FAK(J)
  100 WRITE(6,1004) ATEXT(I),(BIJ(J),SBIJ(J),J=1,6)
      RETURN
 1000 FORMAT(/14X,'DIRECT',30X,'RECIPROCAL'/2(7X,'AXES',13X,'ANGLES'9X))
 1001 FORMAT(1X,F8.4,'(',I6,')',F10.3,'(',I6,')',F13.6,'(',I6,')',
     1        F10.3,'(',I6,')')
 1002 FORMAT(/7X,'VOLUME='F8.2,'(',I6,')',14X,'VOLUME=',F9.7,'(',I6,')')
 1003 FORMAT('0THERMAL B-FACTORS AND STANDARD DEVIATIONS.  B(I,J)=BIJ',
     1       '/A(I)STAR*A(J)STAR*0.25 = 8*PI*PI*M.S.AMPLITUDE',//,
     2       ' ATOM',9X,'B(1,1)',13X,'B(2,2)',13X,'B(3,3)',13X,'B(1,2)',
     3       13X,'B(1,3)',13X,'B(2,3)')
 1004 FORMAT(1X,A4,6(3X,F7.4,'(',F7.4,')'))
      END
