      REAL FUNCTION DAWSON(X)
      REAL X
*
*      This program calculates the Dawson's integral
*                 x 
*        -x*x    / t*t
*       e     * / e   dt
*              /
*             0
*      according to approximations by Cody, Paciorek, & Thacher.
*
*      Four argument regions are considered:
*
*      a) Abs(x) .le. 2.5
*      b) Abs(x) .gt. 2.5 .and. Abs(x) .le. 3.5
*      c) Abs(x) .gt. 3.5 .and. Abs(x) .le. 5.0
*      d) Abs(x) .gt. 5.0.
*
      INTEGER I
      REAL X2,Y,Y1,Y2
      REAL P(6),Q(6),A1(5),B1(4),A2(4),B2(3),A3(4),B3(3)
*
      DATA P/10832.6559,-1284.05832,419.672902,-15.1982152,1.67795116,
     *       -0.0238594566/
      DATA Q/10832.6559,5937.71277,1489.43557,219.728332,19.9422336,1.0/
      DATA A1/0.500652754,-4.91605366,4.07068102,-12.6817902,3.47393743/
      DATA B1/0.214221966,37.3902764,13.8216341,88.7619387/
      DATA A2/0.500009652,-1.58539350,-10.3850248,-4.10832338/
      DATA B2/0.249246324,-0.537142730,17.7617781/
      DATA A3/0.500000002,-2.50017117,-4.67312022,-11.1952164/
      DATA B3/0.749999191,-2.48787659,-4.12544066/
*
      X2=X*X
      IF(ABS(X) .LE. 2.5) THEN
         Y1=P(6)
         DO 10 I=5,1,-1
10       Y1=P(I)+X2*Y1
         Y2=Q(6)
         DO 20 I=5,1,-1
20       Y2=Q(I)+X2*Y2
         DAWSON=X*Y1/Y2
      ELSE IF(ABS(X) .LE. 3.5) THEN
         Y=A1(5)
         DO 30 I=4,1,-1
30       Y=A1(I)+B1(I)/(X2+Y)
         DAWSON=Y/X
      ELSE IF(ABS(X) .LE. 5.0) THEN
         Y=A2(4)
         DO 40 I=3,1,-1
40       Y=A2(I)+B2(I)/(X2+Y)
         DAWSON=Y/X
      ELSE
         Y=A3(4)
         DO 50 I=3,1,-1
50       Y=A3(I)+B3(I)/(X2+Y)
         DAWSON=(1+Y/X2)/(2*X)
      END IF
      RETURN
      END
