*     **********************************
      FUNCTION CUBHAR(L,M,COSTHE,COSPHI)
*     **********************************
*
      INTEGER L,M
      REAL K,COSTHE,COSPHI
*
*     This subroutine evaluates cubic harmonic functions
*     K  (theta,phi).
*      lm
*
*     Global statements
*
      X2 = (1-COSTHE**2)*COSPHI**2
      X4 = X2*X2
      X6 = X4*X2
      Y2 = (1-COSTHE**2)*(1-COSPHI**2)
      Y4 = Y2*Y2
      Y6 = Y4*Y2
      Z2 = COSTHE**2
      Z4 = Z2*Z2
      Z6 = Z4*Z2
*
*     Branch with l - values 4, 6 and 8 are allowed.
*
      GO TO (120,120,120,40,120,60,120,80),L
      GO TO 120
   40 K=2.5*(X4+Y4+Z4)-1.5
      GO TO 110
   60 IF(M .EQ. 1) THEN
         K=(693*(X6+Y6+Z6)-945*(X4+Y4+Z4)+270)/32
      ELSE IF(M .EQ. 2) THEN
         K=10.39230485*((Y2-Z2)*X4+(Z2-Z2)*Y4+(X2-Y2)*Z4)
      ELSE
         GO TO 120
      END IF
      GO TO 110
   80 IF(M .EQ. 1) THEN
         K=(195*(X6*X2+Y6*Y2+Z6*Z2)-364*(X6+Y6+Z6)+105*(X4+Y4+Z4)-35)/6
      ELSE
         GO TO 120
      END IF
  110 CUBHAR=K
      RETURN
*
*     Error: L or M is illegal.
*
  120 WRITE(6,1000) L,M
      STOP
 1000 FORMAT('In CUBHAR: Invalid indices; L =',I3,' M =',I3,'.')
      END
