*     ***********************
      SUBROUTINE COORD(HKL,I)
*     ***********************
      INTEGER I
      REAL HKL(3)
*
*     This subroutine sets the correct cartesian coordinate orientation
*     according to space symmetry.
*     Cell dimensions in /SPACE/ and Miller indices H, K and L for
*     reflection I are used. JUMP specifies the symmetry.
*
      INTEGER JUMP
      REAL H,K,L
      REAL A,B,C,COSALF,COSBET,COSGAM,SINALF,SINBET,SINGAM
      INCLUDE 'BLANK.FOR'
      COMMON/SPACE/JUMP,A,B,C,COSALF,COSBET,COSGAM,SINALF,SINBET,SINGAM

      H=HKL(1)
      K=HKL(2)
      L=HKL(3)
*
*     Branch according to the structure
*
      GO TO (10,20,30,30,30,60,60,80,80,80,80,120,120),JUMP
      GO TO 150
*
*     Triclinic         -- Space groups 1   ...   2
*
  10  S11=(B*C*SINALF)**2
      S12=A*B*C*C*(COSALF*COSBET-COSGAM)
      S22=(A*C*SINBET)**2
      S33=(A*B*SINGAM)**2
      S23=A*A*B*C*(COSBET*COSGAM-COSALF)
      S13=A*B*B*C*(COSGAM*COSALF-COSBET)
*
      D=SQRT(S33*(S11*H*H+S22*K*K+S33*L*L+2*(S23*K*L+S13*H*L+S12*H*K)))
      CT=(S33*L+S23*K+S13*H)/D
      D=SQRT(S11*(S11*H*H+S22*K*K+2*S12*H*K))
      CP=(S11*H+S12*K)/D
      GO TO 140
*
*     Monoclinic        -- Space groups 3   ...  15  -  b-axis unique
*
  20  D=(H/A)**2+(L/C)**2-2*H*L*COSBET/(A*C)
      IF(D.EQ.0) THEN
         CP=1
      ELSE
         CP=(H/A-L*COSBET/C)/SQRT(D)
      END IF
      CT=K*SINBET/(B*SQRT(D+(K*SINBET/B)**2))
      GO TO 140
*
*     Orthorhombic      -- Space groups 16  ...  74
*
  30  D=SQRT((H/A)**2+(K/B)**2+(L/C)**2)
      IF(JUMP.EQ.3) THEN
*                                  Case A: a-axis unique
         CT=H/(A*D)
         OVER=K/B
         UNDER=SQRT((K/B)**2+(L/C)**2)
      ELSE IF(JUMP.EQ.4) THEN
*                                  Case B: b-axis unique
         CT=K/(B*D)
         OVER=L/C
         UNDER=SQRT((H/A)**2+(L/C)**2)
*                                  Case C: c-axis unique
      ELSE
         CT=L/(C*D)
         OVER=H/A
         UNDER=SQRT((H/A)**2+(K/B)**2)
      END IF
      IF(UNDER.EQ.0) THEN
         CP=1
      ELSE
         CP=OVER/UNDER
      END IF
      GO TO 140
*
*     Tetragonal          -- Space groups 75  ... 142
*
   60 D=SQRT((H*H+K*K)/(A*A)+(L/C)**2)
      CT=L/(C*D)
      IF(H*H+K*K.EQ.0) THEN
         CP=1
      ELSE
         CP=H/SQRT(H*H+K*K)
      END IF
      GO TO 140
*
*     Trigonal            -- Space groups 143 ... 167
*     Hexagonal           -- Space groups 168 ... 194
*
   80 D=H*H+K*K+H*K
      CT=0.8660254038*A*L/(C*SQRT(D+3*(A*L/(2*C))**2))
      IF(D.EQ.0) THEN
         CP=1
      ELSE
         CP=(H+0.5*K)/SQRT(D)
      END IF
      GO TO 140
*
*     Cubic               -- Space groups 195 ... 230
*
  120 D=H*H+K*K
      CT=L/SQRT(D+L*L)
      IF(D.EQ.0) THEN
         CP=1
      ELSE
         CP=H/SQRT(D)
      END IF
*
*     Get rid of rounding errors.
*
  140 IF(ABS(CT).GT.1) CT=SIGN(1.0,CT)
      IF(ABS(CP).GT.1) CP=SIGN(1.0,CP)
      COSTHE(I)=CT
      COSPHI(I)=CP
      RETURN
  150 WRITE(6,1000) JUMP
      STOP
 1000 FORMAT(' In COORD: Invalid symmetry; JUMP =',I5,'.')
      END
