*     ***********************
      SUBROUTINE CONPRE(C,CF)
*     ***********************
*
*     This subroutine prepares the elements of the bordering matrix due
*     to the constraint functions.
*
      REAL CF(4),C(51,4)
      INCLUDE 'BLANK.FOR'
      COMMON/CONSTR/ML,LN(4),COEF(4,10),IL(4,9),JL(4,9),IQ(4,9),JQ(4,9)
      DO 10 J=1,MAXCON
      DO 10 I=1,MAXS
   10 C(I,J)=0
      DO 20 I=1,MAXCON
      CF(I)=COEF(I,10)
*
*     I chooses the constraint and J goes thru all terms in left-hand
*     side of constraint equation.
*
      LNI=LN(I)
      DO 20 J=1,LNI
*
*     For linear constraints IL(I,J) chooses category, that is,
*     instrument, crystal or atom parameter and JL(I,J) chooses the
*     particular parameter inside the category.
*     For quadratic constraints IQ(I,J) chooses the category and
*     JQ(I,J) chooses the parameter.
*     AA is the coefficient in the constraint equation.
*
      AA=COEF(I,J)
      CALL PICK(IL(I,J),JL(I,J),A,L,P)
      IF(I.LE.ML) THEN
         C(L,I)=AA*A+C(L,I)
         CF(I)=CF(I)-AA*P
      ELSE
         CALL PICK(IQ(I,J),JQ(I,J),B,M,Q)
         C(L,I)=AA*A*Q+C(L,I)
         C(M,I)=AA*B*P+C(M,I)
         CF(I)=CF(I)-AA*P*Q
      END IF
   20 CONTINUE
      RETURN
      END
