#include "snd.h"

static XtInputId clm_id;

void CLM_disconnect(snd_state *ss)
{
  if (clm_id) XtRemoveInput(clm_id);
  ss->to_clm = 0;
}

static void GetClmString (XtPointer clientData, int *fd, XtInputId *id)
{
  get_clm_string((snd_state *)clientData,*fd);
}

static char connected_msg[] = "(print \"Snd connected\")";

void CLM_connect(snd_state *ss)
{
  /* look for CLM fifo -- if found, establish connection and X input callback */
  state_context *sx;
  sx = ss->sgx;
  ss->from_clm = open("/tmp/clm_snd_fifo",O_RDWR,0);
  if (ss->from_clm != -1)
    {
      ss->to_clm = open("/tmp/snd_clm_fifo",O_RDWR,0);
      clm_id = XtAppAddInput(sx->mainapp,ss->from_clm,(XtPointer)XtInputReadMask,GetClmString,(XtPointer)ss);
      /* now tell CLM we're here (it is waiting...) */
      write(ss->to_clm,connected_msg,strlen(connected_msg)+1);
    }
  else 
    {
      ss->to_clm = 0;
      clm_id = 0;
    }
}

/* now the "clm is awaiting snd data" dialog */

static Widget clm_fd = NULL;

static void clm_help_callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss = (snd_state *)clientData;
  snd_help(ss,
	   "CLM Snd",
"CLM is awaiting a response from Snd.  If\n\
you click 'ok', the current changed data will\n\
be sent.  Click 'cancel' to cancel the\n\
transaction.\n\
");
}

void cleanup_clm_dialog(snd_state *ss)
{
  if ((clm_fd) && (XtIsManaged(clm_fd)))
    {
      write(ss->to_clm,":cancel",8);
      XtUnmanageChild(clm_fd);
    }
}

static void clm_cancel_callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss = (snd_state *)clientData;
  write(ss->to_clm,":cancel",8);
}

static void clm_ok_callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss = (snd_state *)clientData;
  write(ss->to_clm,":ok",4);
}

void start_clm_dialog(snd_state *ss, char *msg, int beg, int num)
{
  Arg args[20];
  int n;
  XmString xmstr1,xmstr2,xmstr3,xmstr4;
  if (!clm_fd)
    {
      /* create dialog */
      n=0;
      xmstr1=XmStringCreateLocalized(msg);
      xmstr2=XmStringCreateLocalized(snd_string_Ok);
      xmstr3=XmStringCreateLocalized(snd_string_Cancel);
      xmstr4=XmStringCreateLocalized(snd_string_Help);
      XtSetArg(args[n],XmNmessageString,xmstr1); n++;
      XtSetArg(args[n],XmNokLabelString,xmstr2); n++;
      XtSetArg(args[n],XmNcancelLabelString,xmstr3); n++;
      XtSetArg(args[n],XmNhelpLabelString,xmstr4); n++;
#ifdef LINUX
      XtSetArg(args[n],XmNresizePolicy,XmRESIZE_GROW); n++;
      XtSetArg(args[n],XmNnoResize,FALSE); n++;
#endif
      clm_fd = XmCreateMessageDialog(main_PANE(ss),"clm",args,n);
      XmStringFree(xmstr1);
      XmStringFree(xmstr2);
      XmStringFree(xmstr3);
      XmStringFree(xmstr4);
      XtUnmanageChild(XmMessageBoxGetChild(clm_fd,XmDIALOG_SYMBOL_LABEL));
      XtAddCallback(clm_fd,XmNhelpCallback,clm_help_callback,ss);
      XtAddCallback(clm_fd,XmNcancelCallback,clm_cancel_callback,ss);
      XtAddCallback(clm_fd,XmNokCallback,clm_ok_callback,ss);
      if (!(ss->using_schemes)) map_over_children(clm_fd,set_main_color_of_widget,(void *)ss);
    }
  else
    {  
      xmstr1=XmStringCreateLocalized(msg);
      XtVaSetValues(clm_fd,XmNmessageString,xmstr1,NULL);
      XmStringFree(xmstr1);      
    }
  if (!(XtIsManaged(clm_fd))) XtManageChild(clm_fd);
}

