/* prototypes for all C functions that might be externally visible */

#ifndef CMUS_PROTOTYPES_H_LOADED
#define CMUS_PROTOTYPES_H_LOADED

/* 3-July-95 */

/* io.c */
  void clm_printf(char *str);
#if defined(PPC) || defined(SGI)
  void set_lisp_printf(void (*lp)()) ;
#endif
  short big_endian_short(short n);
  short little_endian_short(short n);
  int big_endian_int(int n);
  int little_endian_int(int n);
  float little_endian_float(unsigned char *buf);
  float big_endian_float(unsigned char *buf);
  double little_endian_double(unsigned char *buf);
  double big_endian_double(unsigned char *buf);
  unsigned short big_endian_unsigned_short(unsigned short n);
  unsigned short little_endian_unsigned_short(unsigned short n);
  float from_vax_float(unsigned int intp);
  int *makearray(int len);
  void freearray(int *ip);
  int setarray(int *arr, int i, int val);
  int getarray(int *arr, int i);
  int incarray(int *arr, int i, int val);
  void cleararray1(int beg, int end, int *arr);
  void normarray(int size, float *arr);
  void arrblt(int beg, int end, int newbeg, int *arr);
#ifndef GCL
  long excl_timedabsmaxarr(int beg, int end, int *maxA, int *arr);
#endif
  int absmaxarr(int beg, int end, int *arr);
  int open_clm_file (int tfd);
  void open_clm_file_descriptors (int tfd, int df, int ds, int dl);
  void close_clm_file_descriptors(int tfd);
  int clm_open_read(char *arg);
  int clm_open_write(char *arg);
  int clm_create(char *arg);
  int clm_reopen_write(char *arg);
  void clm_close(int fd);
  long clm_seek(int tfd, long offset, int origin);
  void make_sound_file(char *filename, float *data, int len, int srate, int channels);
#ifndef GCL
  long excl_clm_seek(int tfd, int *offset, int origin);
#endif
  void clm_read(int fd, int beg, int end, int chans, int **bufs);
  void clm_read_chans(int fd, int beg, int end, int chans, int **bufs, int *cm);
  void clm_write_zeros(int tfd, int num);
  void clm_write(int tfd, int beg, int end, int chans, int **bufs);
  int clm_read_floats(int fd,int n,float *arr);
  int clm_read_swapped_floats(int fd,int n,float *arr);
  int clm_read_ints(int fd,int n,int *arr);
  int clm_read_swapped_ints(int fd,int n,int *arr);
  int clm_write_floats(int fd,int n,float *arr);
  void clm_seek_floats(int fd,int n);
  void clm_seek_bytes(int fd,int n);
#ifndef PPC
  sigfnc *clm_signal(int signo, sigfnc *fnc);
#endif

/* headers.c */
  int c_snd_header_data_size (void);
  int c_snd_header_data_location (void);
  int c_snd_header_chans (void);
  int c_snd_header_srate (void);
  int c_snd_header_type (void);
  int c_snd_header_format (void);
  int c_snd_header_distributed (void);
  int c_snd_header_comment_start (void);
  int c_snd_header_comment_end (void);
  int c_snd_header_type_specifier (void);
  int c_snd_header_bits_per_sample (void);
  int c_snd_header_fact_samples (void);
  int c_snd_header_block_align (void);
  int c_true_file_length (void);
  int c_snd_header_original_format (void);
  void c_set_snd_header (int in_srate, int in_chans, int in_format);
  int c_snd_datum_size (int format);
  int c_snd_header_datum_size (void);
  int c_snd_bytes (int format, int size);
  int c_snd_samples (int format, int size);
  void write_next_header (int chan, int srate, int chans, int loc, int siz, int format, char *comment, int len);
  void c_read_header_with_fd (int chan);
  int c_read_header (char *name);
  int c_write_header (char *name, int type, int srate, int chans, int loc, int size, int format, char *comment, int len);
  void c_update_header_with_fd(int chan, int type, int siz);
  int c_update_header (char *name, int type, int size, int srate, int format, int chans, int loc);
#ifndef GCL
  int excl_c_update_header (char *name, int type, int *siz, int srate, int format, int chans, int loc);
  int excl_c_write_header (char *name, int type, int srate, int chans, int loc, int *siz, int format, char *comment, int len);
#endif
  int c_snd_header_aux_comment_start (int n);
  int c_snd_header_aux_comment_end (int n);
  int match_four_chars(unsigned char *head, const unsigned char *match);
  int c_update_header_comment (char *name, int loc, char *comment, int len, int typ);
  void create_header_buffer (int *buf);

/* cmus.c */
  void clm_file_reset(int loc0, int *io, int *datai);
  void clm_full_file_reset(int loc, int *io, int *datai);
  void c_newline(void);
  void c_init_sine (void);
  float c_sin_lookup(float phase);
  float c_frandom(float amp);
  void c_srand(int val);
  void c_fft_window(float *rl, float *win, int size);
  void c_clear_block(float *rl, int size);
  void c_blti(int *arr0, int beg, int *arr1, int len);
  void c_bltf(float *arr0, int beg, float *arr1, int len);
  int c_gcd(int a, int b);
  int c_lcm(int a, int b);
  float c_table_interp (float *fn, float xx, int len);
  float c_table_lookup (int *tbl, float *datar, float fm);
  float c_direct_flt (int m, float input, float *flt_a, float *flt_b, float *flt_d);
  float c_lattice_flt (int m, float input, float *flt_a, float *flt_b, float *flt_d);
  float c_ladder_flt (int m, float input, float so, float *flt_a, float *flt_b, float *flt_c, float *flt_d);
  int c_y_or_n_p (void);
  int c_yes_or_no_p (void);
  void c_fft (float* rl, float* im, int n, int isign, int ipow);
  void convolve (float* rl1, float* rl2, int n, int ipow);
  void c_env_restart (float *ef, int *ei, float *data);
  float c_env (float *ef, int *ei, float *data);
  void c_access_env (int val, float *ef, int *ei, float *data);
  double jv_exp(double x);
  float c_run_block (int *blk, float *fblk, float *buf);
  void c_base_run_block (int *blk, float *fblk, float *buf);
  float c_readin (int *rd, int *io, int *datai);
  float c_src(int *rd, int *rio, int *datai, float *srf, int *sri, float *data, float *filt, float fm, float *sinc, float *fblk, float *buf);
  float c_spd (int *rddat, int *spidat, float *spfdat, int *io, int *datai, float *b, float *fblk, float *buf);
  void set_expansion_triggers (int *rddat, int *spidat, float *fblk, float *buf);
  void add_one_segment (int *rd, int *spidat, float *spfdat, int *rio, int *datai, float *b, float *buf);
  float c_fft_filter (int *rddat, int *io, int *iobufs, int *runblk, float *fblk, int *fftdat,
		      float *runbuf, float *datar, float *datai, float *fenv, float *rfblk, float *rbuf);
  void c_convolve (char *fname, 
                   int filec, int filehdr,
                   int filterc, int filterhdr, int filtersize,
                   int start, int fftsize, int ipow, int chans, int chan);
  float c_convolve_or_readin (int *rddat, int *io, int *iobufs, int *runblk, float *fblk, int *fftdat,
			      float *runbuf, float *datar, float *datai, float *filtr, int filti, float *rfblk, float *rbuf);
  void load_one_sine (float partial, float amp, float *table, int table_size, float phase);
  void initialize_pool (void);
  void c_add_pool_open_index (int n);
  int c_read_pool_open_index(int *inds);
  void finalize_ins (int id);
  int c_scheduler_active (void);
  void finalize_pool (int outadr, int revadr, int *datai);
  void initialize_ins (int beg_sample, int end_sample, int out_adr, int rev_adr,
	  	       int *datai, int leni, float *datar, int lenr, 
		       void (*loop_function)());

  void set_clm_var_table_size (int size);
  void allocate_clm_var (int index, int type, int size, int cleared);
  int get_clm_var_table_size (void);
  int get_int_clm_var (int index, int type);
  int get_int_aref_clm_var (int index, int arrind, int type);
  int set_int_clm_var (int index, int val, int type);
  int set_int_aref_clm_var (int index, int arrind, int val, int type);
  float get_float_clm_var (int index, int type);
  float get_float_aref_clm_var (int index, int arrind, int type);
  float set_float_clm_var (int index, float val, int type);
  float set_float_aref_clm_var (int index, int arrind, float val, int type);
#ifdef PPC
  void mcl_get_float_clm_var (int index, int type, double *df);
  void mcl_get_float_aref_clm_var (int index, int arrind, int type, double *df);
  void mcl_set_float_clm_var (int index, double *val, int type);
  void mcl_set_float_aref_clm_var (int index, int arrind, double *val, int type);
#endif

  void create_sine_table (int *buf);
  void make_sines(int length);
  void c_fht (int powerOfFour, float *array);
  void c_fft_magnitude(float *rl, float *im, int size);
  void c_spectrum(float *rdat, float *idat, float *window, int n);
  void create_pool (int *buf);
  void reset_pool (void);
  void create_clm_vars(int *buf);

/* merge.c */
  int c_fasmix(char *ofile, char *ifile, int osample, int isample, int samples, int *channel_matrix, int *datai, float *datar);
  void c_mixem (int **obuf, int **ibuf, int obeg, int beg, int oend, int *datai, float *datar, int *channel_matrix, int ochans, int ichans);

  void f_merge_read(int fd, int first, int samples, int **bufs, double sr, int dataloc, int ichans, int need_filter, float *datar, int *cm);
  void i_merge_read(int fd, int first, int samples, int **bufs, int sr, int dataloc, int ichans, int need_filter, float *datar, int *cm);
  void fasmix_read_header(int fd);
  void create_fasmix_arrays (void);
  int c_find_max_amp(char *ifile, int *vals);
  void set_up_fasmix(double fxloc, int fixloc, int fcurfloc, int channels, int **fibufs, int **fobufs);

#ifdef PPC
  void mac_mix_in_place (int **obuf, int **ibuf, int obeg, int ibeg, int oend, int *datai, double *df, int len,
		       int *channel_matrix, int ochans, int ichans);
  int mac_fasmix(char *ofile, char *ifile, int osample, int isample, int samples,
               int *channel_matrix, int *datai, double *df, int len);
#endif

/* dacs.c */
#ifndef SND_H
  void write_dac (char *buf, int chars, int cadr);
  void close_dac (void);
  int open_dac (int srate, int chans);

  int open_adc(int srate, int chans);
  void close_adc(void);
  float read_adc(void);
  int adc_chans(void);
#endif

  void create_descriptors (int *buf);
  void set_rt_audio_p (int rt, int *links);
  void set_rt_record_p (int rt, int *links);
  int clm_read_any(int tfd, int beg, int chans, int nints, int **bufs, int *cm);

#ifdef CLM_NO_RLD
  void link_header_buffer (int *buf);
  void link_sine_table (int *buf);
  void link_descriptors (int *buf);
#endif
  int link_table_size (void);
  void link_pool (int *buf);
  void link_clm_vars(int *buf);
#endif
