/* header for cmus generated c files and its associated library */

#ifndef CMUS_H_LOADED
#define CMUS_H_LOADED
#define one_pi 3.141592653589793
#define two_pi 6.283185307179586
#define minus_two_pi -6.283185307179586
#define half_pi 1.5707963267948966
#define three_half_pi 4.71238898038469
#define inverse_pi 0.15915494309189535

#define clm_sndfix 32768.0
#define clm_sndflt 0.000030517578

#ifndef NULL
  #define NULL 0
#endif

/* linker locations */
#define LINK_DATUM_FORMAT 0
#define LINK_DATUM_SIZE 1
#define LINK_DATUM_LOCATION 2
#define LINK_FILES 3
#define LINK_SINE_TABLE 4
#define LINK_HEADER_BUFFER 5
#define LINK_POOL_ID 6
#define LINK_POOL_END 7
#define LINK_POOL_SAMPLE 8
#define LINK_POOL_OPEN_INDEX 9
#define LINK_POOL_OUTN 10
/* LINK_POOL_FINISH removed 5-Feb-97 */
#define LINK_POOL_LOOP 12
#define LINK_POOL_DATAI 13
#define LINK_POOL_DATAR 14
#define LINK_POOL_GLOBALS 15
#define LINK_AUX_COMMENT_START 16
#define LINK_AUX_COMMENT_END 17
#define LINK_CLM_VAR_SIZE 18
#define LINK_CLM_VARS 19
#define LINK_RT_AUDIO_P 20
#define LINK_CLM_CLEARED_VARS 21
#define LINK_CLM_VAR_DESCRIPTORS 22
#define LINK_POOL_RECN 23
#define LINK_RT_RECORD_P 24
#define LINK_TABLE_SIZE 25

/* on the SGI, local variables must be explicitly linked via this table at initialization time
 * via (sound.lisp) clm-initialize-links and (in *.c) functions (tied via gcl-clm.lisp and c-io.lisp)
 * that create and link the locals.  All non-constant arrays are dynamically allocated, and references to them
 * are handled via lisp.  All other locals are declared static and are actually never touched in
 * the instruments.  The only drawback of this business is that every instrument has its own copy
 * of the code.
 */



/* now try to figure out what type machine we're on */

#ifdef __LITTLE_ENDIAN__
  /* NeXTStep on Intel */
  #define CLM_LITTLE_ENDIAN 1
#else
  #ifdef BYTE_ORDER
    #if BYTE_ORDER == LITTLE_ENDIAN
    /* SGI possibility (/usr/include/sys/endian.h), and Linux (/usr/include/bytesex.h and endian.h) */
    #define CLM_LITTLE_ENDIAN 2
    #endif
  #endif
#endif


/* and whether we have to build our own run-time linker */

#if defined(SGI) || defined(PPC) || defined(EXCL_LINUX)
  #define CLM_NO_RLD 1
#endif


#define cl_false 1234567
#define cl_true  7654321
#define DAC_CHANNEL 252525
#define DAC_REVERB 252520
#define CLM_FATAL_WRITE_ERROR 7
#define ERROR_C 10
#define BREAK_C 11
#define FUNCTION_C 12
#define SIGINT_C 13

/* io file structure reflected in datai */
#define io_fd 0
#define io_chans 1
#define io_size 2
#define io_beg 3
#define io_end 4
#define io_bufsiz 5
#define io_data_start 6
#define io_data_end 7
#define io_open_index 8
#define io_dir 9
#define io_loc 10
#define io_hdr_end 11
#define io_incr 12
#define io_dats 13

#define c_aref_block 0
#define c_aref_type 1
#define c_aref_size 2
#define c_aref_element_size 3
#define c_aref_dims 4
#define c_aref_dim_list_adr 5

#define io_in_f 0
#define io_out_f 1

#ifndef PPC
#ifndef CLM_SIGFNC_DEFINED
#define CLM_SIGFNC_DEFINED
  typedef void sigfnc(int);
#endif
#endif
#endif
