/* Sound display/edit/etc
 *
 * a re-implementation in summer 1996 of my much-missed dpysnd -- the Foonly/SAIL/E/Mus10/Grnlib sound editor from ca 1983.
 * with much help from Douglas Young's "The X Window System, Programming and Applications with Xt" Prentice-Hall 1994.
 *
 *
 * Snd code is split between the sound editor proper (every file without an 'x' in the name),
 * and anything that is specific to X/Motif.  To port to another window system, it should be 
 * sufficient to reimplement whatever is in snd-x*.h, and approximate the user interface in 
 * snd-xmain, snd-xsnd, and snd-xchn.  Except for tempnam, the DAC stuff in snd-dac, and 
 * open/read (I like unbuffered IO), all the code is (or is thought to be) straight ANSI C.
 *
 *
 * On the SGI:
 * if you want to use SGI's enhanced widgets and 'schemes', use this sequence in the makefile:
 *
 *              -laudio -lSgw -lSgm -lXmu -lXm -lXt -lX11 -lPW -lc -lm -ly
 *
 * then make a file named Snd on your home directory, and insert:
 *
*sgiMode:        true
*useSchemes:     all
*scheme:         Base
 *
 * or whatever scheme you want.  Then, in a shell
 * 
xrdb -load Snd
 * 
 * Snd-specific resources are lightestcolor, basiccolor, darkcolor, darkestcolor, textcolor, mixercolor,
 *                            boldbuttonFont, buttonFont, axisLabelFont, axisNumbersFont, cursorcolor,
 *                            selectioncolor, initFile, epsFile, backupFile, defaultOutputType
 * see Snd.ad for an app-defaults file setting these to their default values.
 */

#include "snd.h"
/* #include <locale.h> */

#ifdef SGI
  #include <sys/fpu.h>
#endif

int main (int argc, char **argv)
{
  snd_state *state;                      /* global state info, carried around via callData arg in callbacks */
  /* there are also 2 global variables -- 
   *    snd_IO_error which parallels C's errno, 
   *    snd_search_fd which provides global access to the current active data.
   */
#ifdef SGI
  union fpc_csr f; f.fc_word = get_fpc_csr(); f.fc_struct.flush = 1; set_fpc_csr(f.fc_word);
#endif
  check_for_remote_possibility(argc,argv);
  create_header_buffer();
  create_descriptors ();
  init_regions();
  /* if (setlocale(LC_ALL,"") == NULL) setlocale(LC_ALL,"C"); */
  /* apparently handled in Xt toolkit via XtSetLanguageProc (snd-xmain.c) */
  /* in Linux with Metrolink Motif 2.0, there's XLocale.h but do I need it? */
  
  state=(snd_state *)calloc(1,sizeof(snd_state));
  state->s_type = make_snd_pointer_type(SND_STATE);
  state->global_fft_size = 256;
  state->global_fft_window = default_fft_window(NULL);
  state->subsampling = 1;
  state->graph_style = graph_lines;
  state->selected_sound = NO_SELECTION;
  state->peaking = 0;
  state->dBing = 0;
  state->logxing = 0;
  state->viewing = 0;
  state->zero_visible = 0;
  state->marks_visible = 0;
  state->from_clm = 0;
  state->to_clm = 0;
  state->clm_selectable = 0;
  state->from_snd = 0;
  state->mx_sp = NULL;
  state->editor_line_size = 128;
  state->fft_style = normal_fft;
  state->max_sounds = 4;                 /* expands to accomodate any number of files */
  state->sounds = (snd_info **)calloc(state->max_sounds,sizeof(snd_info *));
  state->default_output_type = DEFAULT_OUTPUT_TYPE;
  state->remember_state = 0;
  state->pending_open = NULL;
  state->auto_open = 1;
  state->fit_data = -1;
  state->global_combining = CHANNELS_SEPARATE;
  state->dot_size = 1;
  state->wavo = 0;
  state->zoom_focus_anchor = FOCUS_ACTIVE;
  state->temp_dir = NULL;
  state->ask_before_overwrite = 0;
  reset_spectro(state);
  state->session_name = NULL;
  state->consoling = 1;
  state->x_axis_style = X_IN_SECONDS;
  state->speed_style = SPEED_AS_FLOAT;
  state->speed_tones = 12;
  state->ngroups = 6;
  state->window_width = 0;
  state->window_height = 0;
  state->movies = 1;
  state->mix_duration_brackets = 0;

  state->initx0 = 0.0;
  state->initx1 = 0.1;
  state->inity0 = -1.0;
  state->inity1 = 1.0;
  state->xmax = 0.0;
  state->xmin = 0.0;
  state->ymax = 1.0;
  state->ymin = -1.0;

  state->gexp_seglen = .15;             /* for eventual "browser" -- not currently of much use */
  state->gexp_ramp = .4;
  state->gexp_hop = .05;
  state->grevfb = 1.09;
  state->grevlp = 0.7;
  state->reverb_decay = 1.0;             /* secs */
  state->normalize_fft = 1;
  state->zero_pad = 0;

  state->include_cwd = 0;

  snd_IO_error = snd_no_error;
  snd_doit(state,argc,argv);
}

/* snd change log
 *
 * 13-Aug:   [space] to pause/continue playback.
 * 11-Aug:   an icon and other sound support improvements in Linux.
 * 6-Aug:    more Linux fixups.
 * 25-July:  record file menu option added.
 * 20-July:  searching bugs fixed. global-set-key added. space cancels selection. 
             Display normalization changed. Snd to CLM communication improved (m-x lisp expr).
 * 10-July:  more region improvements.
 * 8-July:   cursor play stuff caused seg fault in region play.  no-rld stuff removed.
 * 26-June:  added y1..8 in parser.
 * 24-June:  click mix console brings it to top of stack.
 * 23-June:  C-x C-j: goto mix and other mix-<> functions. cursor follows play upon control-click.
 * 20-June:  group/mixer support.  File save-as now remains in current file, rather than switching to new.
 * 10-June:  print dialog. superimposed channel graphs (part 1).
 * 6-June:   various expression-related bugs.
 * 4-June:   first portion of group editor.
 * 19-May:   click file name for info.  
 * 16-May:   cursor changes. sync'd mixes. green sashes!
 * 13-May:   %spectrum works for normal fft.  Sound control labels are clickable.  Added initial-x0 and friends.
 * 5-May:    support for explode in CLM with-sound. dB for sonogram etc.
 * 23-Apr:   normalize-fft added, better spectrum rotations.
 * 14-Apr:   first mix console step. expand clicks fixed. 
 * 4-Apr:    speed style option menu, associated variables.
 * 20-Mar:   file update option added. Most dialogs now not transient (not auto-raised). Added -remote switch.
 * 18-Mar:   x axis units option.
 * 17-Mar:   session options. selection play fixed.
 * 14-Mar:   scale-by, scale-to, amp-envelope, with selection cases added. More header types.
 * 1-Mar:    data command for clm through-snd.
 * 24-Feb:   Next switches, sessions, ufun action lists, more linux bugs.
 * 17-Feb:   file browser (view files) added.
 * 12-Feb:   save-as dialog improved
 * 10-Feb:   view color and orientation menu options, with associated color variables.
 * 31-Jan:   file-loadable filter/envelopes.
 * 27-Jan:   1+1 where i+1 intended in spectrum!
 * 24-Jan:   memory leaks and other bugs
 * 20-Jan:   improved spectrogram rotation, added keypad keymap, wavogram.
 * 17-Jan:   dot-size. 'unite' button and Combine channels menu option. zoom focus choices (option menu).
 * 8-Jan-97: fixed bug in fft peak calculation. Save-As in Edit menu improved.
 * ---------
 * 30-Dec:   clm display hooks.
 * 23-Dec:   amp env improved.
 * 18-Dec:   new file option smarter, spectrogram improved.
 * 16-Dec:   more clm-snd connections, peaks command.
 * 9-Dec:    added Info menu option, save-marks.  More Linux bugs fixed.
 * 4-Dec:    Linux fixups (XmCreateMessageDialog -> bad drawable)
 * 20-Nov:   clm marks, fixed several apply and aiff header bugs
 * 24-Oct:   more Linux changes
 * 18-Oct:   Linux port. added (info), c-X c-V
 * 30-Sep:   added snd-trans.c
 * 17-Sep:   better support for schemes, cross disk saves
 * 9-Sep-96: launched!
 */
