#define FILE_BUFFER_SIZE 8192
#define MAX_BUFFER_SIZE 65536
#define MAX_FILE_NAME 128       /* max file name length */
#define MIX_FILE_BUFFER_SIZE 2048

#define SCROLLBAR_MAX 100       /* used by zx, zy, and sy, but not sx (huge files need special handling) */

#define DEFAULT_OUTPUT_TYPE NeXT_sound_file

enum {W_chn_main_window,   /* top window for chan */
      W_chn_wf_buttons,
      W_chn_left_scrollers,W_chn_bottom_scrollers,W_chn_graph,    
                           /* direct children of main_window */
      W_chn_sx,W_chn_zx,   /* scroll bars in bottom_scrollers */
      W_chn_gzy,W_chn_gsy, /* scroll bars for combined graphs */
      W_chn_zy,W_chn_sy,   /* scroll bars in left_scrollers */
      W_chn_f,W_chn_w      /* buttons in wf_buttons */
};

#define NUM_CHAN_WIDGETS 13

#define NO_SELECTION -1

enum {W_snd_pane,
      W_snd_name_form,W_snd_amp_form,
      W_snd_amp,W_snd_amp_label,W_snd_amp_number,W_snd_amp_separator,
      W_snd_srate,W_snd_srate_label,W_snd_srate_number,W_snd_srate_arrow,
      W_snd_expand,W_snd_expand_label,W_snd_expand_number,W_snd_expand_button,
      W_snd_contrast,W_snd_contrast_label,W_snd_contrast_number,W_snd_contrast_button,
      W_snd_revscl,W_snd_revscl_label,W_snd_revscl_number,
      W_snd_revlen,W_snd_revlen_label,W_snd_revlen_number,W_snd_reverb_button,
      W_snd_filter_label,W_snd_filter_order,W_snd_filter_env,W_snd_filter,W_snd_filter_button,
      W_snd_record_sep,W_snd_record,W_snd_replay,W_snd_apply,W_snd_set,W_snd_reset,
      W_snd_name,W_snd_info_label,W_snd_info,
      W_snd_info_sep,
      W_snd_play,W_snd_sync,W_snd_combine,
      W_snd_ctrls
};
/* order matters here -- W_snd_ctrls should be last */

#define NUM_SND_WIDGETS 45

typedef struct {unsigned int s_type;} snd_any;

enum {
  TICK_DESCRIPTOR,AXIS_INFO,
  FILE_INFO,FFT_INFO,
  CHAN_INFO,SND_INFO,SND_STATE,FFT_STATE,FFT_WINDOW_STATE,
  ED_LIST,SND_DATA,SND_FD,REGION_INFO,
  UNKNOWN_TYPE
};

enum {graph_lines,graph_dots,graph_bars};
enum {normal_fft,sonogram,spectrogram};
enum {NOGRAPH,WAVE,FFT,UFUN};    /* for marks, regions, mouse click detection */

enum {FOCUS_LEFT,FOCUS_RIGHT,FOCUS_ACTIVE,FOCUS_MIDDLE};
enum {FROM_FILE_MENU,FROM_SELECTION,FROM_UFUN,FROM_KEYBOARD};
enum {DONT_LOCK_MIXES,LOCK_MIXES};
enum {DONT_DELETE_ME,DELETE_ME};

#ifdef NEXT
  #define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
#endif

#define READ_FORWARD 1
#define READ_BACKWARD -1

enum {X_IN_SECONDS,X_IN_SAMPLES,X_TO_ONE};
enum {SPEED_AS_FLOAT,SPEED_AS_RATIO,SPEED_AS_SEMITONE};

enum {MD_CS,MD_TITLE,MD_M};

#define GROUP_MAX_OUT_CHANS 4

#define CURSOR_IN_VIEW 0
#define CURSOR_ON_LEFT 1
#define CURSOR_ON_RIGHT 2
#define CURSOR_IN_MIDDLE 3
#define CURSOR_UPDATE_DISPLAY 4
#define CURSOR_NO_ACTION 5
#define CURSOR_CLAIM_SELECTION 6
#define KEYBOARD_NO_ACTION 7

#define MAX_NUM_PEAKS 100
#define REGIONS 16

enum {GROUP_INITIALIZED,GROUP_ACTIVE,GROUP_CLEARED};
enum {NO_PROBLEM,BLIND_LEAP,GIVE_UP,HUNKER_DOWN};
enum {CHANNELS_SEPARATE,CHANNELS_COMBINED,CHANNELS_SUPERIMPOSED};
enum {FD_INITIALIZED,FD_OPEN,FD_CLOSED};

#define SND_DATA_FILE 0
#define SND_DATA_BUFFER 1

