/* header for cmus generated c files and its associated library */

#ifndef CMUS_H_LOADED
#define CMUS_H_LOADED
#define one_pi 3.141592653589793
#define two_pi 6.283185307179586
#define minus_two_pi -6.283185307179586
#define half_pi 1.5707963267948966
#define three_half_pi 4.71238898038469
#define inverse_pi 0.15915494309189535

#define clm_sndfix 32768.0
#define clm_sndflt 0.000030517578

#ifndef NULL
  #define NULL 0
#endif

/* now try to figure out what type machine we're on */

#ifdef __LITTLE_ENDIAN__
  /* NeXTStep on Intel */
  #define CLM_LITTLE_ENDIAN 1
#else
  #ifdef BYTE_ORDER
    #if BYTE_ORDER == LITTLE_ENDIAN
    /* SGI possibility (/usr/include/sys/endian.h), and Linux (/usr/include/bytesex.h and endian.h) */
    #define CLM_LITTLE_ENDIAN 2
    #endif
  #endif
#endif


#define cl_false 1234567
#define cl_true  7654321
#define DAC_CHANNEL 252525
#define DAC_REVERB 252520
#define CLM_FATAL_WRITE_ERROR 7
#define ERROR_C 10
#define BREAK_C 11
#define FUNCTION_C 12
#define SIGINT_C 13

/* io file structure reflected in datai */
#define io_fd 0
#define io_chans 1
#define io_size 2
#define io_beg 3
#define io_end 4
#define io_bufsiz 5
#define io_data_start 6
#define io_data_end 7
#define io_open_index 8
#define io_dir 9
#define io_loc 10
#define io_hdr_end 11
#define io_incr 12
#define io_dats 13

#define c_aref_block 0
#define c_aref_type 1
#define c_aref_size 2
#define c_aref_element_size 3
#define c_aref_dims 4
#define c_aref_dim_list_adr 5

#define io_in_f 0
#define io_out_f 1

#ifndef PPC
#ifndef CLM_SIGFNC_DEFINED
#define CLM_SIGFNC_DEFINED
  typedef void sigfnc(int);
#endif
#endif

#define CLM_SHM_KEY 0x00636c6d

#endif
