.TH smix 1 "28 Feb 1997" "Release 1" "Linux System Manual"
.SH NAME
.I smix \- A Simple LINUX Mixer Program
.SH SYNOPSIS
.B smix 
[-v] [-h] [-o file] [-i file] [command(s)] 
.SH DESCRIPTION
.I smix
, a simple mixer program that
controls the Mixer settings of
.I /dev/mixer 
from the command line parameter(s).
.PP
The commands are detailed below, capitals showing the minimum abbreviation
allowed. Upper or lower case can be used on the command line. All Volume
settings are in range 0-100 (0 min, 100 max), but these are scaled to the
mixers actual range, hence set volume may be slightly different.

.IP SHow
outputs the settings of the mixer. This is the default 
if no command line parameters are given
.IP dev\ N\ or\ L,R
sets mixer device 'dev' to volume N, or to seperate
left and right stereo volume L,R
If device doesn't support stereo settings then max of L,R
is used.
.IP INput\ dev
set the DSP input to be 'dev' or 'NOne' to turn inputs off
.IP Verbose
makes the program output the settings after doing the
commands
.SH OPTIONS
.IP -h
show usage summary, which also lists the mixer devices and
the possible input devices.
.IP -v
be verbose - outputs the results of commands. Same as Verbose above
.IP -i\ file
read commands from file
.IP -o\ file      
divert standard output to file.
.PP                   
Use '-' as a filename to indicate standard input.
.SH EXAMPLES
.IP smix
Displays the current mixer devices and their current settings.
.IP smix\ input\ line1\ line1\ 60\ mic\ 0\ show
sets input to line1, line1 volume to 60 and mic volume to 0 (off)
and shows the total resultant mixer settings.
.IP smix\ line1\ 60,0\ show
sets left line1 input to volume 60 and right line1 input to 0 (off) and
shows the resultant output.
.IP smix\ -i\ /etc/mixer.default
set the mixer settings from smix commands in /etc/mixer.default.
.SH FILES
.SH
.SH SEE ALSO
All the other mixer programs that float around the internet.
.SH BUGS
.SH
.SH COPYING
.I Copyright 1995, 1996, 1997 the author (see below)
.PP
The software described by this manual is covered by the GNU General
Public License, Version 2, June 1991, issued by :
.IP
Free Software Foundation, Inc.,
.br
675 Mass Ave,
.br
Cambridge, MA 02139, USA
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translation instead of in the original English.
.SH AUTHOR
.I Jim Jackson
.br
.I School of Computer Studies
.br
.I The University of Leeds
.br
.I Leeds, LS2 9JT, UK
.br
.sp
.I Email: jj@scs.leeds.ac.uk
.br
