.TH siggen 1 "28 Feb 1997" "Release 1" "Linux System Manual"
.SH NAME
.I siggen \- an Ncurses based signal generator program
.SH SYNOPSIS
.IP siggen\ [-s\ samplerate]\ [-8|-16|-b\ 8|-b\ 16]\ [-1|-2]
.SH DESCRIPTION
.I siggen
is a simple signal generator program, with an Ncurses based user interface,
that can digitally generate standard waveforms on the LINUX /dev/dsp device.
8 or 16 bit samples can be generated depending on the hardware.
.PP
.I siggen
allows two independant waveforms to be generated.
In stereo the two signals appear on different channels. In mono the two
signals are digitally mixed onto the one mono channel.
.PP
The frequency is
specified as an integer number of Hertz. Fractional Hertz frequencies are
not supported. Of course, only frequencies less than half the samplerate
(number of samples/sec) can be generated.
.PP 
The waveforms that can be generated are:
.IP sine
A standard sine wave
.IP cosine
a sine wave with a 90 degree phase shift
.IP square
a standard square wave with a 50% mark space ratio
.IP triangle
a ramp waveform with 'infinitely' fast flyback (:-) An ideal oscilloscope
timebase signal.
.IP sawtooth
shaped like equally spaced teeth on a saw (:-)
.IP noise
This is weak. All it consists of is one second of pseudo-randomly generated
samples, played repeatedly. I'd love to do proper white/pink noise,
but I don't know enough, and I don't think the structure of the program
is conducive to accurate noise generation.
.IP pulse
A square waveform where the mark/space ratio (as a percentage) can be 
specified. The default value is 10% (mark/space ratio of 1:9).
.PP
.I siggen
creates one second's worth of generated output in a buffer and plays the
buffer repeatedly, until it is terminated.
.PP
A lot of thought has gone into the algorithms for generating the waveforms.
I believe the sin/cos wave to be very pure (modulo your sound card :-), but
I don't have access to a THD meter to measure it. For best signal accuracy
leave the gain setting at 100(%). The generator will then make the wave's
peak value fit the maximum digital values allowed. Use a mixer program to
control the output volume, or an external attenuator.
.PP
The gain factor option can be useful for simulating a signal that has been
subject to clipping, by specifing a gain of > 100%. In fact a trapezoid signal
can be made by generating a clipped sawtooth wave. The greater the gain,
the closer the signal approaches a square wave (the rise and fall times
decrease).
.IP Defaults
output to /dev/dsp, 22050 samples/sec, stereo if stereo card else mono,
16 bit samples if possible, else 8 bit. 
.SH OPTIONS
.IP -h
display usage and help info
.IP -v
be verbose
.IP -s\ samples
generate with samplerate of samples/sec
.IP -8|-16\ or\ -b\ 8|16
force 8 bit or 16 bit mode.
.IP -1|-2
mono or stereo
.SH EXAMPLES
.SH
.SH FILES
.SH
.SH SEE ALSO
sgen
.SH BUGS
.SH
.SH COPYING
.I Copyright 1995, 1996, 1997 the author (see below)
.PP
The software described by this manual is covered by the GNU General
Public License, Version 2, June 1991, issued by :
.IP
Free Software Foundation, Inc.,
.br
675 Mass Ave,
.br
Cambridge, MA 02139, USA
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translation instead of in the original English.
.SH AUTHOR
.I Jim Jackson
.br
.I School of Computer Studies
.br
.I The University of Leeds
.br
.I Leeds, LS2 9JT, UK
.br
.sp
.I Email: jj@scs.leeds.ac.uk
.br
