/* ncfio.h
 * header file for ncurses structured field i/o routines
 * Jim Jackson Nov. 1996
 */

#ifndef __NCFIO_H
#define __NCFIO_H

#include <ncurses/ncurses.h>

/* ====================================================================
 * Functions calls where everything is passed as separate parameters
 */

/* macro function calls.......
 */

#define mvgetfint(L,C,A,IP,W) ((move(L,C)==ERR)?ERR:getfint(A,IP,W))
#define mvputfint(L,C,A,N,W)  ((move(L,C)==ERR)?ERR:putfint(A,N,W))
#define mvgetfstr(L,C,A,P,W) ((move(L,C)==ERR)?ERR:getfstr(A,P,W))
#define mvputfstr(L,C,A,P,W) ((move(L,C)==ERR)?ERR:putfstr(A,P,W))

#define putfopt(A,S,I,W)   putfstr(A,S[I],W)
#define mvgetfopt(L,C,A,P,I,W) ((move(L,C)==ERR)?ERR:getfopt(A,P,I,W))
#define mvputfopt(L,C,A,P,I,W) ((move(L,C)==ERR)?ERR:putfstr(A,P[I],W))

/* ====================================================================
 * Function calls where everything is passed thru' a structure
 */

/* Main io field structure definition .......
 */

struct NCField {
/*   WINDOW *win; */               /* Window this field is in                */
   int type;                   /* type of field - see below              */
   int row;                    /* row and col of start of field          */
   int col;
   int attr;                   /* attribute to use for field             */
   union {
      char *s;                 /* or pointer to string                   */
      char **sp;               /* or a ptr to an array of options        */
      int *i;                  /* integer value of field - see below     */
      float *f;                /* or float value                         */
   } val;
   int W;                      /* width in chars of field                */
   int adj;                    /* a 2nd parameter for some fields        */
};

/* values for the type field define the type of value defined
 * and some simple attributes of the value
 * 
 * integer - is a cash till type integer entry. Cursor stays fixed on right
 * string  - simple string value
 * option  - allows one of a fixed set of values to be choosen
 */

#define NCF_type    0xff
#define NCF_integer 1
#define NCF_string  2
#define NCF_real    3
                               /*  adj>0 defines number of decimal places  */
#define NCF_option  4
#define NCF_fixed   0x100
                               /* field has a fixed value -                */
                               /*  default is NOT fixed                    */
#define NCF_justify 0x200
                               /* field is justified opposite to default   */
                               /* string right justified, int and real left*/

/* macros to
 *  - test NCField type to see if field is not fixed, i.e. an input field
 *  - to force field to be fixed
 *  - to make field an input field, i.e. remove the fixed value
 */

#define can_input(NCFtype)  (!(NCFtype & NCF_fixed))
#define fixed_field(NCFtype) (NCFtype | NCF_fixed)
#define input_field(NCFtype) (NCFtype & (!NCF_fixed))

/* ======================================================================  */

#endif   /*  __NCFIO_H  */
