/* misc.c
 * Miscellaneous Functions 
 * Jim Jackson     Dec 96
 */

/*
 * Copyright (C) 1997 Jim Jackson                    jj@scs.leeds.ac.uk
 *                    School of Computer Studies,
 *                    The University of Leeds,
 *                    Leeds, LS2 9JT, UK
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program - see the file COPYING; if not, write to 
 *  the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 *  MA 02139, USA.
 */

#include <stdio.h>

/*
 *  fputi()
 */

fputi(n,f)
int n;
FILE *f;
{
  if (n<0)
     {
	fputc('-',f); n=-n;
     }
  fputd(n,f);
}

fputd(n,f)
unsigned int n;
FILE *f;
{
  unsigned int i;
  char b[12],*p;

  p=b+11; *p=0;
  if (n)
   { for ( ; n; n/=10 )
      { *--p=n%10+'0'; }
   }
  else *--p='0';
  fputs(p,f);
}  

/***ERR_RPT***/
/* err_rpt(err,msg)
 */

err_rpt(err,msg)
short int err;
char *msg;

 { extern int sys_nerr;
   extern char *sys_errlist[];
   extern char *sys;

   if (err>sys_nerr)
     { fprintf(stderr,"%s: Err %d :-  %s\n",sys,err,msg);
     }
   else if (err) fprintf(stderr,"[%s] %s : %s\n",sys,sys_errlist[err],msg);
   return(err);
 }

/***HCF***/
/* hcf(x,y)   find highest common factor of x and y
 */

hcf(x,y)
unsigned x,y;

{
   register unsigned a,b,r;
   
   if (x>y) {
      a=x; b=y; 
   } else {
      a=y; b=x; 
   }
   for ( ; r=a%b ; a=b, b=r) { }
   return(b);
}

