
#ifndef _MIDI_SYSTEMS_H_
#define _MIDI_SYSTEMS_H_

/* FreeBSD sound support is written as "something a bit like Linux" --
   sorry, but we use Linux ourselves so it's a lot easier for us this
   way.  So if we're on FreeBSD, define the Linux flag as well */

#ifdef SYSTEM_FREEBSD
#define SYSTEM_LINUX
#endif


/* The rest are for Makefile back-compatibility */

#ifdef SEQUENCE_SGI
#define SYSTEM_SGI
#endif

#ifdef RECORD_SGI
#define SYSTEM_SGI
#endif

#ifdef SEQUENCE_ZILOG
#define SYSTEM_ZILOG
#endif

#ifdef RECORD_ZILOG
#define SYSTEM_ZILOG
#endif

#ifdef SEQUENCE_LINUX
#define SYSTEM_LINUX
#endif

#ifdef RECORD_LINUX
#define SYSTEM_LINUX
#endif

#ifdef SYSTEM_SGI
#ifdef SYSTEM_LINUX
#error Too many SYSTEM defines -- SGI and LINUX or FREEBSD
#endif
#ifdef SYSTEM_ZILOG
#error Too many SYSTEM defines -- SGI and ZILOG
#endif
#endif

#ifdef SYSTEM_LINUX
#ifdef SYSTEM_ZILOG
#error Too many SYSTEM defines -- LINUX or FREEBSD and ZILOG
#endif
#endif


/* and finally, SYSTEM_SILENT */

#ifndef SYSTEM_LINUX
#ifndef SYSTEM_ZILOG
#ifndef SYSTEM_SGI
#define SYSTEM_SILENT
#endif
#endif
#endif


#endif /* _SYSTEMS_H_ */

