/*
 *    Rosegarden MIDI Sequencer
 *
 *    File:           Sequence.h
 *
 *    Description:    Prototypes for sequencer playback functions.
 *
 *
 *    Author:         AJG
 *
 *
 *
 *    History:
 *
 *    Update  Date            Programmer      Comments
 *    ======  ====            ==========      ========
 *
 *    001     29/03/94        AJG             File Created.
 *    002     09/08/94        JPff            Midi_SeqOutInit given Boolean
 *                                               value
 *    003     17/02/95        cc              Added #ifdefs for HAVE_Z8530
 *
 */

#ifndef _MIDI_SEQUENCE_H_
#define _MIDI_SEQUENCE_H_

#include "Systems.h"

#ifndef SYSTEM_SGI
#ifndef SYSTEM_ZILOG
#ifndef SYSTEM_LINUX
#ifndef NO_SEQUENCE
#define NO_SEQUENCE 1
#endif /* ! NO_SEQUENCE */
#endif /* ! SYSTEM_LINUX */
#endif /* ! SYSTEM_ZILOG */
#endif /* ! SYSTEM_SGI */

#ifndef NO_SEQUENCE

/* zero for successfully opened */
int Midi_SeqPlayFile(void);

#else /* NO_SEQUENCE */
#define Midi_SeqPlayFile() (1)
#endif /* ! NO_SEQUENCE */



#ifdef SYSTEM_SGI
void Midi_DeviceCloseCB();
void Midi_InitialPatchesDlg();
void Midi_GetDeviceInfo();
#endif



#ifdef SYSTEM_ZILOG
#define Midi_GetDeviceInfo()
void Midi_DeviceCloseCB();
void Midi_InitialPatchesDlg();
#endif



#ifdef SYSTEM_LINUX

void Midi_GetDeviceInfo();
void Midi_DeviceCloseCB();
void Midi_InitialPatchesDlg();
void Midi_LoadFMPatchSet();

#define SYNTH_DEVICE 1
#define MIDI_DEVICE 2

#define SYNTH_PLAYBACK "Synthesiser Playback Selected"
#define MIDI_PLAYBACK "External MIDI Playback Selected"

/* ++++ USS Lite ++++*/

extern unsigned char _seqbuf[];
extern int _seqbuflen;
extern int _seqbufptr;
extern int seqfd;

extern int errno;
extern int midi_dev;

#endif


#endif /* _MIDI_SEQUENCE_H_ */

