/*
 *    Rosegarden MIDI Sequencer
 *
 *    File:           Resources.h
 *
 *    Description:    Definitions of application resources.
 *
 *    Author:         AJG
 *
 * History:
 *
 * Update       Date            Programmer      Comments
 * ======       ====            ==========      ========
 * 001          24/01/94        AJG             File Created.
 * 002          02/10/94        JPff            Added resource for midiPort
 * 003          30/05/96        rwb             Changed default midiPort
 * 004          24/07/96	cc		Added midiFmPatchFile
 */


#define XtNaboutTextFont     "aboutTextFont"
#define XtCAboutTextFont     "AboutTextFont"
#define XtNinterlockWindow   "interlockWindow"
#define XtCInterlockWindow   "InterlockWindow"
#define XtNfoundDefaults     "foundDefaults"
#define XtCFoundDefaults     "FoundDefaults"
#define XtNmusicDirectory    "musicDirectory"
#define XtCmusicDirectory    "MusicDirectory"
#define XtNacceleratorTable  "acceleratorTable"
#define XtCacceleratorTable  "AcceleratorTable"
#define XtNmidiPort	     "midiPort"
#define XtCmidiPort	     "MidiPort"
#define XtNexternalPlayer    "externalPlayer"
#define XtCexternalPlayer    "ExternalPlayer"
#define XtNshouldWarpPointer "shouldWarpPointer"
#define XtCShouldWarpPointer "ShouldWarpPointer"
#define XtNmidiFmPatchFile   "midiFmPatchFile"
#define XtCMidiFmPatchFile   "MidiFmPatchFile"
#define XtNscorePlayTracking "scorePlayTracking"
#define XtCScorePlayTracking "ScorePlayTracking"

static XtResource Midi_Resources[] = 
{
  	{
    		XtNinterlockWindow,
    		XtCInterlockWindow,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, interlockWindow),
    		XtRImmediate,
    		(caddr_t)NULL,
  	},
  	{
    		XtNfoundDefaults,
    		XtCFoundDefaults,
    		XtRBoolean,
    		sizeof(Boolean),
    		XtOffset(AppDataPtr, foundDefaults),
    		XtRImmediate,
    		(caddr_t)False,
  	},
	{
	  	XtNaboutTextFont,
    		XtCAboutTextFont,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, aboutTextFont),
    		XtRImmediate,
    		(caddr_t)"-*-lucida-medium-r-*-*-18-*-*-*-*-*-*-*",
  	},
	{
		XtNmusicDirectory,
		XtCmusicDirectory,
		XtRString,
		sizeof(char *),
		XtOffset(AppDataPtr, musicDirectory),
		(caddr_t)NULL,
	},
 	{
 	    	XtNmidiPort,
     		XtCmidiPort,
     		XtRString,
     		sizeof(char *),
     		XtOffset(AppDataPtr, midiPortName),
     		XtRImmediate,
#ifdef SYSTEM_LINUX
     		(caddr_t)"/dev/sequencer",
#else
#ifdef SYSTEM_SGI
		(caddr_t)"internal",
#else
                (caddr_t)"/dev/ttyd2",
#endif
#endif
   	},
	{
	    	XtNacceleratorTable,
    		XtCacceleratorTable,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, acceleratorTable),
    		XtRImmediate,
    		(caddr_t)NULL,
  	},
	{
	    	XtNexternalPlayer,
    		XtCexternalPlayer,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, externalPlayer),
    		XtRImmediate,
    		(caddr_t)"",
  	},
	{
		XtNshouldWarpPointer,
		XtCShouldWarpPointer,
		XtRBoolean,
		sizeof(Boolean),
		XtOffset(AppDataPtr, shouldWarpPointer),
		XtRImmediate,
		(caddr_t)True,
	},
	{
		XtNmidiFmPatchFile,
		XtCMidiFmPatchFile,
		XtRString,
		sizeof(String),
		XtOffset(AppDataPtr, midiFmPatchFile),
		XtRImmediate,
		(caddr_t)"/usr/local/lib/rosegarden/std.sb",
	},
	{
	        XtNscorePlayTracking,
	        XtCScorePlayTracking,
	        XtRBoolean,
	        sizeof(Boolean),
	        XtOffset(AppDataPtr, scorePlayTracking),
	        XtRImmediate,
	        (caddr_t)True,
	}
};


static XrmOptionDescRec Midi_CommandOptions[] = 
{
    { "-aboutfn",     "*aboutTextFont",     XrmoptionSepArg, NULL },
    { "-ILTopBoxWin", "*interlockWindow",   XrmoptionSepArg, NULL },
    { "-midiport",    "*midiPort",          XrmoptionSepArg, NULL },
    { "-midipatchfile","*midiFmPatchFile",  XrmoptionSepArg, NULL },
};
