/*
 *    Rosegarden MIDI Sequencer
 *
 *    File:           MidiSetupDlgs.h
 *
 *    Description:    Includes and generic sequencing/GUI structures.
 *
 *    Author:         rwb
 *
 *    History:
 *
 *    Update  Date            Programmer      Comments
 *    ======  ====            ==========      ========
 *    001     23/8/96         rwb             File Created.
 *
 */

#ifndef _MIDI_SETUP_DLGS_H_
#define _MIDI_SETUP_DLGS_H_

#include "Systems.h"

#ifdef SYSTEM_LINUX

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef SYSTEM_FREEBSD
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif

#include "Lists.h"

typedef union _DeviceInformation
{
    struct midi_info   Midi;
    struct synth_info  Synth;
} DeviceInformation;

typedef struct _DeviceListElement
{
    ListElement       Scooter;
    int               Type;
    DeviceInformation Port;
} DeviceListElement, *DeviceList;

#endif

#endif

