
/* MenuMarks.c */

/* Musical Notation Editor for X, Chris Cannam 1994 */
/* Functions dealing with the actions available from the Mark menu */


#include "General.h"
#include "Widgets.h"
#include "Menu.h"
#include "Stave.h"
#include "StaveEdit.h"
#include "StavePrivate.h"
#include "ItemList.h"

#include "Yawn.h"


void MarkMenuMark(Widget w, XtPointer client, XtPointer b)
{
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;
  ItemList       list;
  Boolean        haveChord = False;
  ChordMods      mods;
  int            i;
  YMenuElement  *element = (YMenuElement *)client;

  Begin("MarkMenuMark");

  if (!stave || !mstave->sweep.swept || start == end) {
    XBell(display, 70);
    End;
  }

  for (i = 0; i < chordModVisualCount; ++i)
    if (!strncasecmp(element->label,
		     chordModVisuals[i].name, strlen(element->label))) break;

  if (i >= chordModVisualCount) {
    IssueMenuComplaint("Internal problem -- no such modifier. Sorry...");
    End;
  }

  mods = chordModVisuals[i].type;

  if (start) list = iNext(start);
  else       list = mstave->music[staveNo];

  while (list) {

    if (list->item->object_class == ChordClass) {
      haveChord = True;
      ((Chord *)list->item)->chord.modifiers |= mods;
    }

    if (list == end) break;
    list = iNext(list);
  }

  if (!haveChord) {
    IssueMenuComplaint("You can only add marks to chords.");
    End;
  }

  FileMenuMarkChanged(stave, True);
  StaveResetFormatting(stave, staveNo);
  StaveRefreshAsDisplayed(stave);
  End;
}


  
void MarkMenuUnmark(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;
  ItemList       list;
  Boolean        haveChord = False;

  Begin("MarkMenuMark");

  if (!stave || !mstave->sweep.swept || start == end) {
    XBell(display, 70);
    End;
  }

  if (start) list = iNext(start);
  else       list = mstave->music[staveNo];

  while(list) {

    if (list->item->object_class == ChordClass) {
      haveChord = True;
      ((Chord *)list->item)->chord.modifiers = ModNone;
    }

    if (list == end) break;
    list = iNext(list);
  }

  if (!haveChord) {
    IssueMenuComplaint("You can only remove marks from chords.");
    End;
  }

  FileMenuMarkChanged(stave, True);
  StaveResetFormatting(stave, staveNo);
  StaveRefreshAsDisplayed(stave);
  End;
}
