
/*
   Musical Notation Editor for X, Chris Cannam 1994

   Headers for Menu creation/use files
*/


#define CALLBACK(X) void X (Widget w, XtPointer a, XtPointer b)


#ifndef _MUSIC_MENU_
#define _MUSIC_MENU_


#include "General.h"
#include "Tags.h"
#include "Stave.h"
#include "Yawn.h"



extern void    IssueMenuComplaint(String);

extern void    EnterMenuMode(MenuMode);
extern void    LeaveMenuMode(MenuMode);
extern Boolean QueryMenuMode(MenuMode);

extern void    InstallFileMenu(Widget);
extern void    InstallEditMenu(Widget);
extern void    InstallGroupMenu(Widget);
extern void    InstallTextMenu(Widget);
extern void    InstallBarMenu(Widget);
extern void    InstallToolsMenu(Widget);
extern void    InstallPaletteMenu(Widget);
extern void    InstallMarkMenu(Widget);
extern void    InstallStaveMenu(Widget);
extern void    MenuCleanUp(void);

extern CALLBACK( Unimplemented );


#endif /* _MUSIC_MENU_ */




#ifndef _MUSIC_FILEMENU_
#define _MUSIC_FILEMENU_


extern YMenuId fileMenuId;

extern void    InstallFileMenu     (Widget);
extern void    FileMenuCleanUp     (void);

extern void    AddStaveToFileMenu  (MajorStave, String, String);
extern String  GetStaveName        (MajorStave);
extern String  GetStaveFileName    (MajorStave);

extern void    FileMenuMarkChanged (MajorStave, Boolean);
extern Boolean FileMenuIsChanged   (MajorStave);

extern Boolean FileStaveExists     (String);
extern void    FileChangeToStave   (String);
extern void    FileCloseStave      (String);

extern CALLBACK( LoadOld );


#endif /* _MUSIC_FILEMENU_ */




#ifndef _MUSIC_MENUEDIT_
#define _MUSIC_MENUEDIT_


extern CALLBACK( EditMenuDelete         );
extern CALLBACK( EditMenuCopy           );
extern CALLBACK( EditMenuCut            );
extern CALLBACK( EditMenuPaste          );
extern CALLBACK( EditMenuShowClipboard  );
extern CALLBACK( EditMenuSelectBar      );
extern CALLBACK( EditMenuSelectStaff    );
extern CALLBACK( EditMenuChangeChord    );
extern CALLBACK( EditMenuChord          );
extern CALLBACK( EditMenuUnchord        );
extern CALLBACK( EditMenuCreateChord    );


#endif /* _MUSIC_MENUEDIT_ */




#ifndef _MUSIC_MENUSTAVE_
#define _MUSIC_MENUSTAVE_


extern CALLBACK( StaveMenuRenameStave );
extern CALLBACK( StaveMenuNewStave    );
extern CALLBACK( StaveMenuDeleteStave );
extern CALLBACK( StaveMenuEmptyStave  );
extern CALLBACK( StaveMenuFillToEnd   );

extern void FillStaffsToEnd(MajorStave, int, int);


#endif /* _MUSIC_MENUSTAVE_ */




#ifndef _MUSIC_MENUGROUP_
#define _MUSIC_MENUGROUP_


extern CALLBACK( GroupMenuTie          );
extern CALLBACK( GroupMenuSlur         );
extern CALLBACK( GroupMenuCrescendo    );
extern CALLBACK( GroupMenuDecrescendo  );
extern CALLBACK( GroupMenuRemove       );
extern CALLBACK( GroupMenuBeam         );
extern CALLBACK( GroupMenuSimpleTuplet );
extern CALLBACK( GroupMenuTuplet       );
extern CALLBACK( GroupMenuGrace        );
extern CALLBACK( GroupMenuBreakGroup   );
extern CALLBACK( GroupMenuTranspose    );
extern CALLBACK( GroupMenuAutoBeam     );
extern CALLBACK( GroupMenuRetrograde   );
extern CALLBACK( GroupMenuInvert       );

#endif /* _MUSIC_MENUGROUP_ */




#ifndef _MUSIC_MENUBAR_
#define _MUSIC_MENUBAR_

extern void KeyTransposeItemIntoNewKey(Item *, Key *, Key *);

extern CALLBACK( BarMenuTimeSignature  );
extern CALLBACK( BarMenuKeySignature   );
extern CALLBACK( BarMenuMetronome      );
/*extern CALLBACK( BarMenuRemoveTime     );*/
extern CALLBACK( BarMenuRemoveMet      );
extern CALLBACK( BarMenuPlain          );
extern CALLBACK( BarMenuDoubleBar      );
extern CALLBACK( BarMenuRepeatAtStart  );
extern CALLBACK( BarMenuRepeatAtEnd    );

/* BarMenuLabel and BarMenuUnlabel are in MenuText.c, */
/* because they're textual operations.                */


#endif /* _MUSIC_MENUBAR_ */




#ifndef _MUSIC_MENUTEXT_
#define _MUSIC_MENUTEXT_


extern CALLBACK( TextMenuTextAbove     );
extern CALLBACK( TextMenuTextAboveBig  );
extern CALLBACK( TextMenuTextBelow     );
extern CALLBACK( TextMenuTextBelowI    );
extern CALLBACK( TextMenuUnlabelGroup  );
extern CALLBACK( TextMenuUnlabelBar    );
extern CALLBACK( TextMenuUnlabelStaff  );

/* and holding these for MenuBar.c -- the implementation's easier */
/* in the context of a textual manipulation file like this one -- */

extern CALLBACK( BarMenuLabel          );
extern CALLBACK( BarMenuUnlabel        );


#endif /* _MUSIC_MENUTEXT_ */




#ifndef _MUSIC_MENUMARKS_
#define _MUSIC_MENUMARKS_


extern CALLBACK( MarkMenuMark    );
extern CALLBACK( MarkMenuUnmark  );


#endif /* _MUSIC_MENUMARKS_ */




#ifndef _MUSIC_MENUTOOLS_
#define _MUSIC_MENUTOOLS_


extern CALLBACK( ToolsMenuWriteMidi  );
extern CALLBACK( ToolsMenuSequence   );
extern CALLBACK( ToolsMenuPlayMidi   );
extern CALLBACK( ToolsMenuImportMidi );
extern CALLBACK( ToolsMenuExportTeX  );

extern void TrackingCleanUp(void);
extern void ToolsMenuEditILCallback(String);
extern void ToolsMenuFollowILCallback(String);


#endif /* _MUSIC_MENUTOOLS_ */

