#include "strident.h"

extern float fthresh;
extern int rev;
extern int diag;

/* oscillator bank resynthesizer for phase vocoder analyzer
  uses sum of N+1 cosinusoidal table lookup oscillators to 
  compute I (interpolation factor) samples of output O
  from N+1 amplitude and frequency value-pairs in C;
  frequencies are scaled by P */

stribank( C, N, R, Nw, I, P, O, harms, nt )
    float C[], O[], P; int N, Nw, R, I, nt; Varray *harms;
{
  static int 	NP,
		L = 8192,
 		first = 1;
  static float 	Iinv,
		*lastamp,
 		*lastfreq,
 		*index,
		*table_sine,
		**tables;
  static float 	Pinc,
		ffac;
  float		div,
		dif,
  		a,
  		ainc,
  		f,
		finc,
		address;
  int 		amp,
		freq,
  	        tabl,
  		h,
		n,
		i,j,
k,
		chan;
  Extr		ext,
  		extrema();

  if ( first ) {
    float TWOPIoL = TWOPI/L, tabscale;
    first = 0;
    lastamp = (float *) space( N+1, sizeof(float) );
    lastfreq = (float *) space( N+1, sizeof(float) );
    index = (float *) space( N+1, sizeof(float) );
    table_sine = (float *) space( L, sizeof(float) );

    if (nt == 0) {
      tables = (float **) space( Harm_Tables, sizeof(float *) );
      for ( i=0; i < Harm_Tables; i++ )
	*(tables+i) = (float *) space( L, sizeof(float) );
    }
    else {
      tables = (float **) space( nt, sizeof(float *) );
      for ( i=0; i < nt; i++ )
	*(tables+i) = (float *) space( L, sizeof(float) );
    }

    tabscale = ( Nw >= N ? N : 8*N );	/* double check this if it fails */
    for ( n = 0; n < L; n++ )
      table_sine[n] = tabscale*cos( TWOPIoL*n );
    Iinv = 1./I;
    Pinc = P*L/R;
    ffac = P*PI/N;
    if ( P > 1. )
      NP = N/P;
    else
      NP = N;

    if (nt == 0) {
      h = harms->elms;
      tabl_init( h, harms->stor, table_sine, *tables, L );

/*

fprintf(stderr,"%d : ", 0);
for ( k=0; k < harms->elms; k++ )
  fprintf(stderr,"%f ", *(harms->stor+k));
fprintf(stderr,"\n");

*/

      for ( i=1; i < Harm_Tables; i++ ) {
	while ( *((harms->stor)+h-1) <= 0. )
	  --h;
	div = 1.;
	for ( j=h; j > 0; j-- ) {
	  dif = *((harms->stor)+(j-1)) * ( (float) h / (Harm_Tables - (i-1)) / div );
	  if ( dif > *((harms->stor)+(j-1)) )
	    dif = *((harms->stor)+(j-1));
	  *((harms->stor)+(j-1)) -= dif;
	  *(harms->stor) += dif;
	  div *= 2.;
	}

/*

fprintf(stderr,"%d : ", i);
for ( k=0; k < harms->elms; k++ )
fprintf(stderr,"%f ", *(harms->stor+k));
fprintf(stderr,"\n");

*/

	tabl_init( h, harms->stor, table_sine, *(tables+i), L );
      }
    }
    else {
      for ( i=0; i < nt; i++ )
	tabl_init( (harms+i)->elms, (harms+i)->stor, table_sine, *(tables+i), L );
    }
  } 

/*

for(i=0;i<Harm_Tables;i++) {
  for(j=0;j<L;j++) {
    fprintf(stderr,"%f\n",*(*(tables+i)+j));
  }
}

*/

  if (nt == 0)
    nt = Harm_Tables;

/* for each channel, compute I samples using linear
   interpolation on the amplitude and frequency
   control values */ 

    ext = extrema( N, C );
    a = ainc = f = finc = address = 0.;
    for ( chan = 0; chan < NP; chan++ ) {
/*      float a, ainc, f, finc, address; */
	freq = ( amp = ( chan << 1 ) ) + 1;
	if ( C[amp] < synt ) /* skip the little ones */
	    continue;
	C[freq] *= Pinc;
	finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv;


	ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv;
	address = index[chan];

/* accumulate the I samples from each oscillator into
   output array O (initially assumed to be zero);
   f is frequency in Hz scaled by oscillator increment
   factor and pitch (Pinc); a is amplitude; */

	if ( *(C+freq) > fthresh )
	  tabl = (nt - 1);
	else {
	  if (rev)
	    tabl = ( (int) (( (*(C+amp) - ext.min) / 
			(ext.max - ext.min) ) * ( (float) nt - 1. )) ) % nt;
	  else
	    tabl = ( (nt - 1) - (int) (( (*(C+amp) - ext.min) / 
			(ext.max - ext.min) ) * ( (float) nt - 1. )) ) % nt;
	}

	if (diag)
	  fprintf(stderr,"%d %f %f\n", tabl, *(C+freq), *(C+amp));


	for ( n = 0; n < I; n++ ) {
	    O[n] += a * *( *(tables+tabl) + ((int) address) );
	    address += f;
	    while ( address >= L )
		address -= L;
	    while ( address < 0 )
		address += L;
	    a += ainc;
	    f += finc;
	} 

/* save current values for next iteration */

	lastfreq[chan] = C[freq];
	lastamp[chan] = C[amp];
	index[chan] = address;
    }
}

tabl_init(h, harms, l, t, length)
int h, length; float *harms, *l, *t;
{
    int 	i,j;
    float 	crloc = 0.,
    	 	rtnlook();

    for ( i=0; i < length; i++ )
      *(t+i) = 0.;
    for ( i=0; i < h; i++ ) {
      for ( j=0; j < length; j++ )
        *(t+j) += ( rtnlook( (float) (i+1), &crloc, l, length ) * (*(harms+i)) );
      crloc = 0.;
    }
}

float rtnlook( incr, crloc, t, l )
float   incr,
        *crloc,
  	*t;
int     l;
{
    float      rtn;

    while ( ((int) *crloc) > l )
        *crloc -= (float) l;
    while ( ((int) *crloc) < 0 )
        *crloc += (float) l;
    rtn = *(t + ( (int) *crloc ));
    *crloc += incr;
    return rtn;
}


Extr extrema( n, data )
int n; float *data;
{
    int i;
    Extr extr;

    extr.min = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.min > fabs( *(data + (i*2))) )
            extr.min = fabs( *(data + (2*i)) );
    }
    extr.max = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.max < fabs( *(data + (2*i))) )
            extr.max = fabs( *(data + (i*2)) );
    }
    return extr;
}
