#include <stdlib.h>
#include <stdio.h>
#include "pv.h"
#include "crack.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;
int diag = 0;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N = 1024,
		N2,
		Nw = 0,
		D = 128, 
		I = 0,
		i,
		in,
		on,
		eof = 0,
		Np = 0;
    float 	thresh = .1,
		nt = .0000001,
    		nmult = .1,
    		ratio = 1.,
      		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*output;
    double	save = 0.,
		orms,
		squat();
    char	ch,
		*dbuf;
    FILE	*fp;

  if (isatty(0))
    usage(1);

  while( (ch= crack( argc, argv, "R|N|M|D|I|t|n|g|e|dh", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 't':	thresh = atof(arg_option);
			break;
	    case 'n':	nt = atof(arg_option);
			break;
	    case 'g':	nmult = atof(arg_option);
			break;
	    case 'e':	ratio = atof(arg_option);
			break;
	    case 'd':	diag = 1;
			break;
	    case 'h':	usage(1);
	}
  }

  if (ratio == 1.) {
    fprintf(stderr,"unity threshold! sloppy!");
    usage(1);
  }
      
  if (Nw == 0)
    Nw = N;

  if (I == 0)
    I = D;

  PI = 4.*atan(1.);
  TWOPI = 8.*atan(1.);
  N2 = N>>1;

  Wanal = (float *) space( Nw, sizeof(float) );
  Wsyn = (float *) space( Nw, sizeof(float) );
  input = (float *) space( Nw, sizeof(float) );
  Hwin = (float *) space( Nw, sizeof(float) );
  buffer = (float *) space( N, sizeof(float) );
  output = (float *) space( Nw, sizeof(float) );

  makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

  in = -Nw;
  if ( D )
    on = (in*I)/D;
  else
    on = in;

  while ( !eof ) {

    in += D;
    on += I;

    eof = shiftin( input, Nw, D );
    fold( input, Wanal, Nw, buffer, N, in );
    orms = squat( buffer, thresh, ratio, nt, nmult, Nw );
    if (save < orms)
      save = orms;
    overlapadd( buffer, N, Wsyn, output, Nw, on );
    shiftout( output, Nw, I, on );
  }
  fprintf(stderr,"average window rms: %f\n", save);
  exit(0);
}

usage(woof)
int woof;
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"squash:  signal amplitude dynamic compressor and expander\n",
	"squash   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	t:	amplitude threshold\n",
	"	n:	noise threshold\n",
	"	g:	noise gain factor\n",
	"	e:	amplitude adjustment ratio\n",
	"	d:	diagnostic output\n",
	"	h:	this warm and fuzzy place\n");
    exit(woof);
}

