#include <stdlib.h>
#include <stdio.h>
#include "crack.h"
#include "pv.h"

#define allc_min 1024

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

typedef struct {
  float mult;
  float time;
} cooby;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,j,
    		inc = 0,
    		winc = 0,
    		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0,
                nfrs = 0;
    float 	P = 1.,
		len,
		tincr,
                time = 0.,
    		ntime = 0.,
                etime = 0.,
		imult,
		*tvf,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*channel,
		*output,
		**frames;
    char	ch,
		filename[128],
		*space(),
		*dbuf;
    FILE        *fp;
    cooby       *frs;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|P|i|f|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
	      		break;
	    case 'i':	nfrs = atoi(arg_option);
			break;
	    case 'f':	strcpy(filename, arg_option);
			break;
	    case 'h':	usage(1);
	}
    }

    if (nfrs == 0) 
      usage(1);

    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }
    if (D == 0)
      D = N / 8;
    I = D;
    tincr = ( (float) D / R );

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
/*
 * allocate memory
 */

    Wanal = (float *) space( Nw, sizeof(float) );        /* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis windows */
    input = (float *) space( Nw, sizeof(float) );	/* input buffers */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */

    frs = (cooby *) space( sizeof(cooby), nfrs );
    frames = (float **) space( sizeof(float *), nfrs );
    for (i=0; i < nfrs; i++)
      *(frames+i) = (float *) space( sizeof(float), N+2 );

    if ( (fp = fopen( filename, "r" )) == NULL ) {
      fprintf(stderr,"Where is %s?\n", filename);
      exit(-1);
    }

    for ( i=0; i < nfrs; i++ ) {
      fscanf(fp,"%f %f\n", &((frs+i)->time), &((frs+i)->mult));
      if ( fread( *(frames+i), sizeof(float), N+2, stdin ) == 0 )
          fprintf(stderr,"Not enough frame data\n");
    }

    for ( i=0; i < nfrs; i++ ) {
      if (etime > (frs+i)->time) {
	fprintf(stderr,"You can't reverse time...yet!\n");
	exit(-1);
      }
      etime = (frs+i)->time;
    }

/*
 * create windows
 */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );
/*
 * initialize input and output time values (in samples)
 */
    in = -Nw;
    on = (in*I)/D;
    ntime = (frs+1)->time;
/*
 * main loop--perform phase vocoder analysis-resynthesis
 */
    while ( time < etime && inc < nfrs ) {
/*
 * increment times
 */
	on += I;

	imult = (winc * tincr) / ( (frs+(inc+1))->time - (frs+inc)->time );
	for ( i=0; i < N2; i++ ) {
	  if (winc == 0) {
	    *(channel + (2*i)) = *(*(frames+inc)+(2*i));
	    *(channel + (2*i+1)) = *(*(frames+inc)+(2*i+1));
	  }
	  else {
	    *(channel + (2*i)) = *(*(frames+inc)+(2*i)) + imult *
	      	( *(*(frames+inc+1)+(2*i)) - *(*(frames+inc)+(2*i)) );
	    *(channel + (2*i+1)) = *(*(frames+inc)+(2*i+1)) + imult *
	      	( *(*(frames+inc+1)+(2*i+1)) - *(*(frames+inc)+(2*i+1)) );    
	  }
	}
	++winc;
/*
 * at this point channel[2*i] contains amplitude data and
 * channel[2*i+1] contains frequency data (in Hz) for phase
 * vocoder channels i = 0, 1, ... N/2; the center frequency
 * associated with each channel is i*f, where f is the
 * fundamental frequency of analysis R/N; any desired spectral
 * modifications can be made at this point: pitch modifications
 * are generally well suited to oscillator bank resynthesis,
 * while time modifications are generally well (and more
 * efficiently) suited to overlap-add resynthesis
 */
	

	oscbank( channel, N2, NULL, 0, R, Nw, I, P, output );
	shiftout( output, Nw, I, on+Nw-I );


/*	unconvert( channel, buffer, N2, I, R );
	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
*/
	time += tincr;

	if ( time >= ntime ) {
	  ++inc;
	  if ( inc != nfrs )
	    ntime = (frs+inc+1)->time;
	  winc = 0;
	}
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
	"saint:  spectra interpolation synthesizer\n",
	"saint:  [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	P:	pitch factor\n",
	"	i:	number of input frames\n",
	"	f:      frame location file\n");
    exit(woof);
}
