#include <stdlib.h>
#include <stdio.h>
#include "crack.h"
#include "pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0,
		Np = 0;
    float 	P = 0.,
		len,
		tincr,
		tpos,
		*tvf,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*lpcoef,
		*buffer,
		*channel,
		*output,
		lpa(),
		maxamp();
    char	ch,
		*dbuf;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|p|g|ah", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	sscanf(arg_option, "%f", &P);
			break;
	    case 'p':	Np = atoi(arg_option);
			break;
	    case 'g':	sscanf(arg_option, "%f", &synt);
			break;
	    case 'a':	aflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    if (sflag)
	D = 0;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;

/* rewrite with NX malloc() routines */

    lpcoef = (float *) space( Np+1, sizeof(float) );	/* lp coefficients */
    Wanal = (float *) space( Nw, sizeof(float) );	/* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis window */
    input = (float *) space( Nw, sizeof(float) );	/* input buffer */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    winput = (float *) space( Nw, sizeof(float) );	/* windowed input buffer */
    buffer = (float *) space( N, sizeof(float) );	/* FFT buffer */
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */

/* create windows */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

/* initialize input and output time values (in samples) */
    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* main loop--perform phase vocoder analysis-resynthesis */

    while ( !eof ) {

/* increment times */
	in += D;
	on += I;

/* analysis: input D samples; window, fold and rotate input
   samples into FFT buffer; take FFT; and convert to
   amplitude-frequency (phase vocoder) form */
	if ( D == 0 ) {
	    if (Np) {
		for ( hoop=0; hoop < Np+1; hoop++ ) {
		    if ( getfloat(lpcoef+hoop) <= 0 )
			eof = 1;
		}
	    }
	    for ( hoop=0; hoop < N+2; hoop++ ) {
		if ( getfloat(channel+hoop) <= 0 )
		    eof = 1;
	    }
		
	} 
	else {
	    eof = shiftin( input, Nw, D );
	    if ( Np ) {
		vvmult( winput, Hwin, input, Nw );
		lpcoef[0] = lpa( winput, Nw, lpcoef, Np, 0 );
	    }
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    convert( buffer, channel, N2, D, R );
	}

	if ( aflag ) {  /* analysis output */
	    if ( Np )
		fwrite( lpcoef, sizeof(float), Np+1, stdout );
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

/* at this point channel[2*i] contains amplitude data and
   channel[2*i+1] contains frequency data (in Hz) for phase
   vocoder channels i = 0, 1, ... N/2; the center frequency
   associated with each channel is i*f, where f is the
   fundamental frequency of analysis R/N; any desired spectral
   modifications can be made at this point: pitch modifications
   are generally well suited to oscillator bank resynthesis,
   while time modifications are generally well (and more
   efficiently) suited to overlap-add resynthesis */

/* oscillator bank resynthesis */

	if ( obank ) {
	    oscbank( channel, N2, lpcoef, Np, R, Nw, I, P, output );
	    shiftout( output, Nw, I, on+Nw-I );
	} 

/* overlap-add resynthesis */

	else {
	    unconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
	}
    }
    exit(0);
}

vvmult( out, a, b, n ) float *out, *a, *b; int n; {
 register float *lim = out + n;
    while ( out < lim )
	*out++ = *a++ * *b++;
}

float maxamp( in, n, per, ix, sz ) float *in; int n, per, ix, sz; {
 char *malloc(), *calloc();
 float maxof(), *lim = in + n;
 int i, found;
 static float **buf, *mx;
 static int *ptr;
 static int first = 1;
 register int *p;
 register float *b, *m;
    if ( first ) {
	first = 0;
	buf = (float **) malloc( sz*sizeof(float *) );
	for ( i = 0; i < sz; i++ )
	    buf[i] = (float *) calloc( per, sizeof(float) );
	ptr = (int *) calloc( sz, sizeof(int) );
	mx = (float *) calloc( sz, sizeof(float) );
    }
    --ix;
    for (
	b = buf[ix] , p = &ptr[ix] , m = &mx[ix], found = 0;
	in < lim;
	in++
    ) {
	if ( ( *(b+*p) = *in >= 0. ? *in : -*in ) >= *m )
	    found = *m = *(b+*p);
	if ( ++(*p) > per )
	    *p = 0;
    }
    if ( found )
	return( *m );
    else
	return( *m = maxof( b, per ) );
}

float maxof( a, n ) float *a; int n; {
 register float *lim = a + n, m;
    for ( m = *a++; a < lim; a++ )
	if ( *a > m )
	    m = *a;
    return( m );
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
	"pv:  phase vocoder\n",
	"pv   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	P:	oscillator bank pitch factor\n",
	"	f:	time-varying function file\n",
	"	l:	length of input\n",
	"	a:	analysis data output\n",
	"	s:	synthesize analysis input\n",
	"	p:	linear prediction order\n",
	"	g:	oscillator resynthesis gate threshold\n");
    exit(woof);
}
