#include <stdlib.h>
#include "falwell.h"
#include "pv.h"

/*	This routine is a hack of the phase-vocoder convert subroutine.
	It gets the real part of the FFT amplitude for each 'bin' and
	multiplies these by a filter function. */ 
	
immolate( int R, int D, int I, int N2, int obank, float mult, float thresh, float *S1, float *S2, float *C1, float *C2, Tabl *amap )
{
  static int 	first = 1;
  int 		real,
		imag,
		amp,
		freq;
  float 	a1,a2,
		b1,b2,
		pd,
		mag,
		phase,
  		damp;
  static float 	*last1,*last2,
		*ilast,
		fund,
		fact,
		ifact;
  register int 	i;
  int		aind;
  char 		*space();

fprintf(stderr,"amap->tlen: %d\n", amap->tlen);

    if ( first ) {
        first = 0;
        last1 = (float *) space( N2+1, sizeof(float) );
        last2 = (float *) space( N2+1, sizeof(float) );
        ilast = (float *) space( N2+1, sizeof(float) );
        fund = (float) R/(N2<<1);
        fact = R/(D*TWOPI);
        ifact = TWOPI*I/R;
    } 

    for ( i = 0; i <= N2; i++ ) {
	imag = freq = ( real = amp = i<<1 ) + 1;

	a1 = ( i == N2 ? *(S1+1) : *(S1+real) );
	b1 = ( i == 0 || i == N2 ? 0. : *(S1+imag) );
	a2 = ( i == N2 ? *(S2+1) : *(S2+real) );
	b2 = ( i == 0 || i == N2 ? 0. : *(S2+imag) );

	*(C1+amp) = hypot( a1, b1 );
	*(C2+amp) = hypot( a2, b2 );

	if ( *(C1+amp) == 0. )
	  pd = 0.;
	else {
	  pd = ( phase = -atan2( b1,a1 ) ) - *(last1+i);
	  *(last1+i) = phase;
	  while ( pd > PI )
	    pd -= TWOPI;
	  while ( pd < -PI )
	    pd += TWOPI;
	}

	*(C1+freq) = pd * fact + i * fund;

	if ( *(C2+amp) == 0. )
	  pd = 0.;
	else {
	  pd = ( phase = -atan2( b2,a2 ) ) - *(last2+i);
	  *(last2+i) = phase;
	  while ( pd > PI )
	    pd -= TWOPI;
	  while ( pd < -PI )
	    pd += TWOPI;
	}

	*(C2+freq) = pd * fact + i * fund;
    }
  
/*
  for ( i=0; i < 2*(N2)+2; i++ )
    *(C1+i) = *(C2+i);
*/

    for ( i = 0; i <= N2; i++ ) {
      freq = (amp = i<<1) + 1;
      damp =  *(C2+amp) - *(C1+amp);
      aind = ( fabs(damp) < thresh ? (int) (fabs(damp) * amap->tlen) :
	     amap->tlen );
      *(C1+amp) = ( *(C1+amp) + (damp * mult) ) * *(amap->tabl+aind);
      *(C1+freq) += ( ( *(C2+freq) - *(C1+freq) ) * mult );
    }

    if (!obank) {
      for ( i = 0; i <= N2; i++ ) {
          imag = freq = ( real = amp = i<<1 ) + 1;
	  if ( i == N2 )
            real = 1;
	  mag = *(C1+amp);
	  *(ilast+i) += *(C1+freq) - i * fund;
	  phase = *(ilast+i) * ifact;
	  *(S1+real) = mag*cos( phase );
	  if ( i != N2 )
            *(S1+imag) = -mag*sin( phase );
      }
    }
}





