#include "taint.h"
#include "sfheader.h"
#include "crack.h"


complex zero = { 0., 0. };
complex one = { 1., 0. };
double PI;
double TWOPI;
double synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,
		invert = 0,
		in,
		on,
		eof = 0,
		aflag = 0,
     		real, imag,
		amp,
		phase;
    float	*output;
    double	a1,a2,
		b1,b2,
    	 	*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*buff1,
                *buff2,
		*chan1,
                *chan2,

    		mult = 1.;
    char	ch,
		file1[128],
                file2[128],
		*dbuf;
    FILE	*fp1,
                *fp2;

    if (argc < 3)
	usage(1);

    

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|F|m|iah", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(file1, arg_option);
			break;
	    case 'F':	strcpy(file2, arg_option);
			break;
	    case 'm':   mult = atof(arg_option);
	                break;
	    case 'a':	aflag = 1;
			break;
	    case 'i':	invert = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (D == 0)
      D = N / 8;

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (double *) space( Nw, sizeof(double) );
    Wsyn = (double *) space( Nw, sizeof(double) );
    input1 = (double *) space( Nw, sizeof(double) );
    input2 = (double *) space( Nw, sizeof(double) );
    Hwin = (double *) space( Nw, sizeof(double) );
    buff1 = (double *) space( N, sizeof(double) );
    buff2 = (double *) space( N, sizeof(double) );
    chan1 = (double *) space( N+2, sizeof(double) );
    chan2 = (double *) space( N+2, sizeof(double) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* open input files */
    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if ( (fp2 = fopen( file2, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file2);
	exit(-1);
    }
    
    (void) stripheader(fp1);
    (void) stripheader(fp2);


    while ( !eof ) {

	in += D;
	on += I;

	eof = tannin( input1, Nw, D, fp1 );
	if (eof)
	    (void) tannin( input2, Nw, D, fp2 );
	else
	    eof = tannin( input2, Nw, D, fp2 );

	fold( input1, Wanal, Nw, buff1, N, in );
	fold( input2, Wanal, Nw, buff2, N, in );
	rfft( buff1, N2, FORWARD );
	rfft( buff2, N2, FORWARD );

	for ( i = 0 ; i <= N2 ; i++ ) {
	  imag = phase = ( real = amp = i<<1 ) + 1 ;
	  a1 = ( i == N2 ? *(buff1+1) : *(buff1+real) ) ;
	  b1 = ( i == 0 || i == N2 ? 0. : *(buff1+imag) ) ;
	  a2 = ( i == N2 ? *(buff2+1) : *(buff2+real) ) ;
	  b2 = ( i == 0 || i == N2 ? 0. : *(buff2+imag) ) ;
	  *(chan1+amp) = hypot( a1, b1 );
	  *(chan1+phase) = -atan2( b1, a1 );
	  *(chan2+amp) = hypot( a2, b2 );
	  *(chan2+phase) = -atan2( b2, a2 );
	}
	
	if (invert) {
	  for ( i=0; i <= N2; i++ ) {
	    amp = i<<1;

	    *(chan1+amp) *= ( (1. / ( *(chan2+amp) )) * mult );
fprintf( stderr,"%f\n", *(chan2+amp) );
	  }
	}
	else {
	  for ( i=0; i <= N2; i++ ) {
	    amp = i<<1;
	    *(chan1+amp) *= (*(chan2+amp) * mult);
fprintf(stderr,"%f\n", *(chan1+amp));
	  }
	}

	for ( i = 0 ; i <= N2 ; i++ ) {
	  imag = phase = ( real = amp = i<<1 ) + 1 ;
	  *(buff1+real) = *(chan1+amp) * cos( *(chan1+phase) );
	  if ( i != N2 ) 
	    *(chan1+imag) = -*(chan1+amp) * sin( *(chan1+phase) );
	}
	
	if ( I == 0 ) {
	    fwrite( chan1, sizeof(double), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buff1, N2, INVERSE );
	overlapadd( buff1, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

void stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
	"taint:  FFT based spectral interpolation\n",
	"taint   [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	source soundfile\n",
	"	F:	filter soundfile\n",
	"	m:	filtering multiplier\n",
	"	i:	inverse filtering\n",
	"	a:	analysis data output\n");
    exit(woof);
}

