#include <stdlib.h>
#include <math.h>
#include "pv.h"
#include "stridex.h"

/* oscillator bank resynthesizer for phase vocoder analyzer
  uses sum of N+1 cosinusoidal table lookup oscillators to 
  compute I (interpolation factor) samples of output O
  from N+1 amplitude and frequency value-pairs in C;
  frequencies are scaled by P */

stribank( C, N, R, Nw, I, P, O, harms, nt )
    float C[], O[], P; int N, Nw, R, I, nt; Harry *harms;
{
  static int 	NP,
		L = 65536,
 		first = 1;
  static float 	Iinv,
		*lastamp,
 		*lastfreq,
 		**index,
		*table_sine,
		**tables;
  static float 	Pinc,
		ffac;
  float		div,
		dif,
  		a,
  		ainc,
  		f,
		finc,
		address;
  int 		amp,
		freq,
  	        tabl,
  		h,
		n,
		i,j,
		chan;
  Extr		ext,
  		extrema();

  if (nt == 0)
    nt = Harm_Tables;

/* FIRST TIME ONLY: allocate memory to hold previous values
   of amplitude and frequency for each channel, the table
   index for each oscillator, and the table itself; also
   compute constants */

  if ( first ) {
    float TWOPIoL = TWOPI/L, tabscale;
    first = 0;
    lastamp = (float *) space( N+1, sizeof(float) );
    lastfreq = (float *) space( N+1, sizeof(float) );
    table_sine = (float *) space( L, sizeof(float) );
    index = (float **) space( nt, sizeof(float *) );
    for ( i=0; i < nt; i++ )
      *(index+i) = (float *) space( N+1, sizeof(float) );

    tabscale = ( Nw >= N ? N : 8*N );	/* double check this if it fails */
    for ( n = 0; n < L; n++ )
      table_sine[n] = tabscale*cos( TWOPIoL*n );
    Iinv = 1./I;
    Pinc = P*L/R;
    ffac = P*PI/N;
    if ( P > 1. )
      NP = N/P;
    else
      NP = N;


    if (nt == 0) {
      h = harms->elms;

      for ( i=0; i < h; i++ )
	*(harms->harm+i) = (float) (i+1);

      for ( i=1; i < Harm_Tables; i++ ) {
	for ( j=0; j < harms->elms; j++ ) {
	  *(harms+i->stor+j) = *(harms+(i-1)->stor+j);
	  *(harms+i->harm+j) = *(harms+(i-1)->harm+j);
	}
	while ( *((harms+i->stor)+h-1) <= 0. )
	  --h;
	div = 1.;
	for ( j=h; j > 0; j-- ) {
	  dif = *((harms+i->stor)+(j-1)) * ( (float) h / (Harm_Tables - 
			(i-1)) / div );
	  if ( dif > *((harms+i->stor)+(j-1)) )
	    dif = *((harms+i->stor)+(j-1));
	  *((harms+i->stor)+(j-1)) -= dif;
	  *(harms+i->stor) += dif;
	  div *= 2.;
	}
      }
    }
    for ( i=0; i< Harm_Tables; i++ ) {
      for ( j=0; j < harms->elms; j++ ) {
	fprintf(stderr,"%f %f ", *(harms+i->harm+j), *(harms+i->stor+j)); 
      }
      fprintf(stderr,"\n");
    }
  }
exit(-1);
/* for each channel, compute I samples using linear
   interpolation on the amplitude and frequency
   control values */ 

    ext = extrema( N, C );
    a = ainc = f = finc = address = 0.;
    for ( chan = 0; chan < NP; chan++ ) {
/*      float a, ainc, f, finc, address; */
	freq = ( amp = ( chan << 1 ) ) + 1;
	if ( C[amp] < synt ) /* skip the little ones */
	    continue;
	C[freq] *= Pinc;
	finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv;


	ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv;

/* accumulate the I samples from each oscillator into
   output array O (initially assumed to be zero);
   f is frequency in Hz scaled by oscillator increment
   factor and pitch (Pinc); a is amplitude; */

	tabl = ((int) (( (*(C+amp) - ext.min) / ext.max ) * 
			 ( (float) nt - 1. )) % nt);
	for ( n = 0; n < I; n++ ) {
	  for ( i=0; i < number of harmonics; i++ ) {
	    address = *(*(index+i)+chan);
	    
	    O[n] += a * *( *(tables+tabl) + ((int) address) );
	    address += f;
	    while ( address >= L )
	      address -= L;
	    while ( address < 0 )
	      address += L;
	    *(index+i)+chan) = address;
	  }
	  a += ainc;
	  f += finc;
        } 

/* save current values for next iteration */


	lastfreq[chan] = C[freq];
	lastamp[chan] = C[amp];
    }
}

tabl_init(h, harms, l, t, length)
int h, length; float *harms, *l, *t;
{
    int 	i,j;
    float 	crloc = 0.,
    	 	rtnlook();

    for ( i=0; i < length; i++ )
      *(t+i) = 0.;
    for ( i=0; i < h; i++ ) {
      for ( j=0; j < length; j++ )
        *(t+j) += ( rtnlook( (float) (i+1), &crloc, l, length ) * (*(harms+i)) );
      crloc = 0.;
    }
}

float rtnlook( incr, crloc, t, l )
float   incr,
        *crloc,
  	*t;
int     l;
{
    float      rtn;

    while ( ((int) *crloc) > l )
        *crloc -= (float) l;
    while ( ((int) *crloc) < 0 )
        *crloc += (float) l;
    rtn = *(t + ( (int) *crloc ));
    *crloc += incr;
    return rtn;
}


Extr extrema( n, data )
int n; float *data;
{
    int i;
    Extr extr;

    extr.min = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.min > fabs( *(data + (i*2))) )
            extr.min = fabs( *(data + (2*i)) );
    }
    extr.max = *data;
    for( i=0; i < n; i++ ) {
        if ( extr.max < fabs( *(data + (2*i))) )
            extr.max = fabs( *(data + (i*2)) );
    }
    return extr;
}
