#include <stdio.h>
#include "sfheader.h"
#include "crack.h"
#include "pv.h"

complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float PI ;
float TWOPI ;
float synt = 0.;

main(argc, argv)
    int argc ; char *argv[] ;
{
    int 	R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		aflag = 0,
		sflag = 0,
		Np = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*lpcoef,
		*buffer1,
                *buffer2,
		*channel1,
                *channel2,
		*output,
                mult = .5,              /* interpolation multiplier */
		lpa(),
		maxamp();
    char	ch,
		file1[128],
                file2[128],
		*dbuf;
    FILE	*fp1,
                *fp2;

    if (argc < 3)
	usage(1);

    

    while( (ch= crack( argc, argv, "R|N|M|D|I|m|ah", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'm':   sscanf(arg_option, "%f", &mult);
	                break;
	    case 'a':	aflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    strcpy(file1, *(argv+1));
    strcpy(file2, *(argv+2));

    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }

    if (sflag)
	D = 0;
    else {
      if (D == 0)
	D = N / 8;
    }

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    PI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;
/*
 * allocate memory
 */
    Wanal = (float *) space( Nw, sizeof(float) );        /* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis windows */
    input1 = (float *) space( Nw, sizeof(float) );	/* input buffers */
    input2 = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    lpcoef = (float *) space( Np+1, sizeof(float) );	/* lp coefficients */
    buffer1 = (float *) space( N, sizeof(float) );	/* FFT buffer */
    buffer2 = (float *) space( N, sizeof(float) );
    channel1 = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    channel2 = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */
/*
 * create windows
 */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 ) ;
/*
 * initialize input and output time values (in samples)
 */
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;

/* open input files */
    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if ( (fp2 = fopen( file2, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file2);
	exit(-1);
    }
    
    (void) stripheader(fp1);
    (void) stripheader(fp2);

/*
 * main loop--perform phase vocoder analysis-resynthesis
 */
    while ( !eof ) {
/*
 * increment times
 */
	in += D ;
	on += I ;
/*
 * analysis: input D samples; window, fold and rotate input
 * samples into FFT buffer; take FFT; and convert to
 * amplitude-frequency (phase vocoder) form
 */

	eof = turnin( input1, Nw, D, fp1 ) ;
	if (eof)
	    (void) turnin( input2, Nw, D, fp2 ) ;
	else
	    eof = turnin( input2, Nw, D, fp2 );

	fold( input1, Wanal, Nw, buffer1, N, in ) ;
	fold( input2, Wanal, Nw, buffer2, N, in ) ;
	rfft( buffer1, N2, FORWARD ) ;
	rfft( buffer2, N2, FORWARD ) ;
	turnip( buffer1, buffer2, channel1, channel2, N2, mult );
	
	if ( I == 0 ) {
	    fwrite( channel1, sizeof(float), N+2, stdout ) ;
	    fflush( stdout ) ;
	    continue ;
	}
/*
 * overlap-add resynthesis
 */
	rfft( buffer1, N2, INVERSE ) ;
	overlapadd( buffer1, N, Wsyn, output, Nw, on ) ;
	shiftout( output, Nw, I, on ) ;
    }
    exit( 0 ) ;
}

vvmult( out, a, b, n ) float *out, *a, *b ; int n ; {
 register float *lim = out + n ;
    while ( out < lim )
	*out++ = *a++ * *b++ ;
}

float maxamp( in, n, per, ix, sz ) float *in ; int n, per, ix, sz ; {
/* char *malloc(), *calloc() ; */
 float maxof(), *lim = in + n ;
 int i, found ;
 static float **buf, *mx ;
 static int *ptr ;
 static int first = 1 ;
 register int *p ;
 register float *b, *m ;
    if ( first ) {
	first = 0 ;
	buf = (float **) malloc( sz*sizeof(float *) ) ;
	for ( i = 0 ; i < sz ; i++ )
	    buf[i] = (float *) calloc( per, sizeof(float) ) ;
	ptr = (int *) calloc( sz, sizeof(int) ) ;
	mx = (float *) calloc( sz, sizeof(float) ) ;
    }
    --ix ;
    for (
	b = buf[ix] , p = &ptr[ix] , m = &mx[ix], found = 0 ;
	in < lim ;
	in++
    ) {
	if ( ( *(b+*p) = *in >= 0. ? *in : -*in ) >= *m )
	    found = *m = *(b+*p) ;
	if ( ++(*p) > per )
	    *p = 0 ;
    }
    if ( found )
	return( *m ) ;
    else
	return( *m = maxof( b, per ) ) ;
}

float maxof( a, n ) float *a ; int n ; {
 register float *lim = a + n, m ;
    for ( m = *a++ ; a < lim ; a++ )
	if ( *a > m )
	    m = *a ;
    return( m ) ;
}

void stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s",
	"turnip:  FFT based spectral interpolation\n",
	"turnip file1 file2  [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	m:	interpolation multiplier\n",
	"	a:	analysis data output\n",
	"	s:	synthesize analysis input\n");
    exit(woof);
}

