#include <stdlib.h>
#include <stdio.h>
#include "pv.h"
#include "crack.h"
#include "taffy.h"

#define Max_Table_Size 32768

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
    		tlen,
		i,
		in,
		on,
		alias = 0,
		eof = 0;
    float 	P = 1.,
    		nyq,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output;
    char	ch,
		file[64],
		*dbuf;
    FILE	*fp;
    Tabl	tfunc;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|f|g|ah", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	sscanf(arg_option, "%f", &P);
			break;
	    case 'f':	if (strcpy(file, arg_option) < 0)
			    fprintf(stderr,"Memory Hoax.\n"),
			    exit(1);
			break;
	    case 'g':	sscanf(arg_option, "%f", &synt);
			break;
	    case 'a':	alias = 1;
	      		break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;
    nyq = ((float) R / 2.);
    tlen = N2;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );
    tfunc.tabl = (float *) space( Max_Table_Size, sizeof(float) );

    if ( (fp = fopen( file, "r" )) == NULL ) {
	fprintf( stderr,"where is %s?\n", file );
	exit(1);
    }

    i = 0;
    while ( (fread((tfunc.tabl)+i, sizeof(float), 1, fp)) != 0 && 
	   i < Max_Table_Size )
      ++i;
    tfunc.tlen = i;

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 1 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {
	in += D;
	on += I;

	if ( D == 0 ) {
    	    if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		eof = 1;
	}     		
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    convert( buffer, channel, N2, D, R );
	}
	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	for ( i=1; i < N; i+=2  ) {
	  if (alias)
            *(channel+i) *= *(tfunc.tabl + (int) (fabs( *(channel+i)
                     / nyq ) * tfunc.tlen));
	  else {
            if (( *(channel+i) *= *(tfunc.tabl + (int) (fabs( *(channel+i)
                     / nyq ) * tfunc.tlen)) ) > nyq)
              *(channel+i) = 0.;
	  }
	}

	noscbank( channel, N2, R, Nw, I, P, output );
	shiftout( output, Nw, I, on+Nw-I );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
	"taffy:  phase vocoder based spectral remapping\n",
	"taffy   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	P:	oscillator bank pitch factor\n",
	"	f:	spectral mapping function file\n",
	"	g:	oscillator resynthesis gate threshold\n"
	"	a:	allow foldover in remapped frequencies\n",
	"	h:	this happy-a-go-go place\n");
    exit(woof);
}
