#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "crack.h"
#include "strident.h"

float fthresh = 4000.;
int diag = 0;
int rev = 0;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		D = 0, 
		I = 0,
		i,j,
		in,
		on,
    		nt = 0,
		eof = 0;
    float 	P = 1.,
    		hoax,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*channel,
		*output;
    char	ch,
    		*space(),
    		filename[128];
    FILE	*fp;
    Varray	*harms;


    synt = .000000001;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|f|g|n|t|rdh", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	sscanf(arg_option, "%f", &P);
			break;
	    case 'f':	strcpy( filename, arg_option );
			break;
	    case 'g':	sscanf(arg_option, "%f", &synt);
			break;
	    case 'n':	nt = atoi(arg_option);
	      		break;
	    case 't':	fthresh = atof(arg_option);
			break;
	    case 'r':	rev = 1;
			break;
	    case 'd':	diag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

/* create windows */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 1 );

/* get harmonics */

    if ( (fp = fopen( filename, "r" )) == NULL ) {
        fprintf( stderr,"what is %s?\n", filename);
        exit(-1);
    }

    if (nt < 0) {
	fprintf(stderr,"you got to have some tables\n");
	usage(1);
    }
    
    if (nt == 0) {
      harms = (Varray *) space( 1, sizeof(Varray) );
      harms->stor = (float *) space( Max_Harm, sizeof(float) );
      i = 0;
      while( (fscanf( fp, "%f", &hoax)) != EOF && i < Max_Harm ) {
	*(harms->stor+i) = hoax;
	++i;
      } 
      harms->elms = i;
    }
    else {
      harms = (Varray *) space( nt, sizeof(Varray) );
      for ( i=0; i < nt; i++ ) 
	(harms+i)->stor = (float *) space( Max_Harm, sizeof(float) );
      for ( j=0; j < nt; j++ ) {
	i = 0;
	while ( (ch=getc(fp)) != '\n' && ch != EOF ) {
          ungetc(ch, fp);
          fscanf(fp,"%f ", &hoax);
	  *((harms+j)->stor+i) = hoax;
	  ++i;
	}
	(harms+j)->elms = i;
      }
    }

/* initialize input and output time values (in samples) */
    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* main loop--perform phase vocoder analysis-resynthesis */

   while ( !eof ) {

/* increment times */
	in += D;
	on += I;

/* analysis: input D samples; window, fold and rotate input
   samples into FFT buffer; take FFT; and convert to
   amplitude-frequency (phase vocoder) form */

	eof = shiftin( input, Nw, D );
	fold( input, Wanal, Nw, buffer, N, in );
	rfft( buffer, N2, FORWARD );
	convert( buffer, channel, N2, D, R );

/* at this point channel[2*i] contains amplitude data and
   channel[2*i+1] contains frequency data (in Hz) for phase
   vocoder channels i = 0, 1, ... N/2; the center frequency
   associated with each channel is i*f, where f is the
   fundamental frequency of analysis R/N; any desired spectral
   modifications can be made at this point: pitch modifications
   are generally well suited to oscillator bank resynthesis,
   while time modifications are generally well (and more
   efficiently) suited to overlap-add resynthesis */

      stribank( channel, N2, R, Nw, I, P, output, harms, nt );
      shiftout( output, Nw, I, on+Nw-I );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"strident:  linear distortion processor\n",
	"strident   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	P:	oscillator bank pitch factor\n",
	"	f:	harmonics data file\n",
	"	n:	number of tables\n",
	"	t:	frequency threshold\n",
	"	g:	oscillator resynthesis gate threshold\n",
	"	r:	reverse mapping of lookup tables\n",
	"	d:	diagnostic output\n",
	"	h:	this happy go-lucky place\n");
    exit(woof);
}
