#include <stdio.h>
#include <stdlib.h>
#include "sfheader.h"
#include "crack.h"
#include "pv.h"

complex zero = {0., 0.};
complex one = {1., 0.};
float PI;
float TWOPI;
float synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		in,
		on,
		eof = 0,
		aflag = 0;
    float	*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*buf1,
                *buf2,
		*chan1,
                *chan2,
		*output;
    char	ch,
		file1[128],
                file2[128],
		*dbuf;
    FILE	*fp1,
                *fp2;

    malloc_debug(32);

    if (argc < 3)
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|F|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(file1, arg_option);
			break;
	    case 'F':	strcpy(file2, arg_option);
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (D == 0)
      D = N / 8;

    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    input1 = (float *) space( Nw, sizeof(float) );
    input2 = (float *) space( Nw, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );
    input1 = (float *) space( Nw, sizeof(float) );
    input2 = (float *) space( Nw, sizeof(float) );
    buf1 = (float *) space( N, sizeof(float) );
    buf2 = (float *) space( N, sizeof(float) );
    chan1 = (float *) space( N+2, sizeof(float) );
    chan2 = (float *) space( N+2, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;



/* open input files */
    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if ( (fp2 = fopen( file2, "r" )) == NULL ) {
      fprintf(stderr,"Where is %s?\n",file2);
      exit(-1);
    }

    (void) stripheader(fp1);
    (void) stripheader(fp2);

    while ( !eof ) {

	in += D;
	on += I;
	
	eof = turnin( input1, Nw, D, fp1 );
	if (eof)
	  (void) turnin( input2, Nw, D, fp2 );
	else
	  eof = turnin( input2, Nw, D, fp2 );


	fold( input1, Wanal, Nw, buf1, N, in );
	fold( input2, Wanal, Nw, buf2, N, in );
	rfft( buf1, N2, FORWARD );
	rfft( buf2, N2, FORWARD );

	{
	  register int	i;
	  int		real, imag,
			amp,
			phase;	
	  float		magn,
			a1,a2,
			b1,b2;

	  for ( i = 0 ; i <= N2 ; i++ ) {
	    imag = phase = ( real = amp = i<<1 ) + 1 ;
	    a1 = ( i == N2 ? *(buf1+1) : *(buf1+real) ) ;
	    b1 = ( i == 0 || i == N2 ? 0. : *(buf1+imag) ) ;
	    a2 = ( i == N2 ? *(buf2+1) : *(buf2+real) ) ;
	      b2 = ( i == 0 || i == N2 ? 0. : *(buf2+imag) ) ;
	    *(chan1+amp) = hypot( a1, b1 );
	    *(chan1+phase) = -atan2( b1, a1 );
	    *(chan2+amp) = hypot( a2, b2 );
	    *(chan2+phase) = -atan2( b2, a2 );
	  }
	    
	
	  for ( i=0; i < N2; i++ )
	    *(chan1+i) = *(chan2+i) - *(chan1+i);
	  
	  for ( i = 0 ; i <= N2 ; i++ ) {
	    imag = phase = ( real = amp = i<<1 ) + 1;
	    *(buf1+real) = *(chan1+amp) * cos( *(chan1+phase) );
	    if ( i != N2 ) 
	      *(buf1+imag) = -*(chan1+amp) * sin( *(chan1+phase) );
	  }
	}
	
	if ( I == 0 ) {
	    fwrite( chan1, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buf1, N2, INVERSE );
	overlapadd( buf1, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

void stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s",
	"fence:  FFT based spectral differential mapping\n",
	"fence   [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	source soundfile\n",
	"	F:	mapping soundfile\n",
	"	s:	single frame remapping\n",
	"	h:	this bovine roadmap\n");
    exit(woof);
}

