#include "pv.h"

/*	This routine is a hack of the phase-vocoder convert subroutine.
	It gets the real part of the FFT amplitude for each 'bin' and
	multiplies these by a filter function.
*/ 
	
void fconvert( float *S, float *C, float *fltbuf, int N2 )
{
 int real, imag, amp, phase;
 float a, b;
 int i;

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	a = ( i == N2 ? S[1] : S[real] );
	b = ( i == 0 || i == N2 ? 0. : S[imag] );
	C[amp] = hypot( a, b );
        C[amp] *= *(fltbuf+i);
	C[phase] = -atan2( b, a );
    }

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	S[real] = *(C+amp) * cos( *(C+phase) );
	if ( i != N2 )
	    S[imag] = -*(C+amp) * sin( *(C+phase) );
    }
}
