#include <stdlib.h>
#include <stdio.h>
#include "pv.h"
#include "crack.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;
int invert = 0;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		in,
		on,
		eof = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*channel,
		*output,
		thresh = .000001,
		fmult = .1;
    char	ch;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|t|m|ih", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 't':	thresh = atof(arg_option);
			break;
	    case 'm':	fmult = atof(arg_option);
			break;
	    case 'i':	invert = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {

	in += D;
	on += I;

	if ( D == 0 ) {
            if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		eof = 1;
	}
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    drowned( buffer, channel, thresh, fmult, N2 );
	}
	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s",
	"drown:  FFT based window filter processor\n",
	"drown   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	t:	threshold for frequency amplitude reduction\n",
	"	m:	reduction multiplier\n",
	"	i:	inverse filter threshold behavior\n",
	"	h:	this love swamped place\n");
    exit(woof);
}


