#include <stdio.h>
#include "pv.h"
#include "crack.h"
#include "sfheader.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R,
		N,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		Np = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output,
		*fltbuf;
    char	ch,
		filename[128],
		*dbuf;
    FILE	*fp;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(filename, arg_option);
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

/* allocate memory */

    Wanal = (float *) space( Nw, sizeof(float) );	/* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis window */
    input = (float *) space( Nw, sizeof(float) );	/* input buffer */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    winput = (float *) space( Nw, sizeof(float) );	/* windowed input buffer */
    buffer = (float *) space( N, sizeof(float) );	/* FFT buffer */
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    fltbuf = (float *) space( (N / 2) + 1, sizeof(float) );  /* filter function buffer */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */

/* create windows */

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

/* initialize input and output time values (in samples) */

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* input convolution soundfile (expects 16-bit integers) */
    

    if ( (fp = fopen( filename, "r" )) == NULL ) {
        fprintf(stderr,"Where is %s?\n",filename);
        exit(-1);
    }

    if (fread(fltbuf, sizeof(float), N2, fp) == 0) {
	fprintf(stderr,"where is the rest?\n");
 	exit(-1);
    }
    
/* main loop--perform phase vocoder analysis-resynthesis */

    while ( !eof ) {

/* increment times */

	in += D;
	on += I;

/* analysis: input D samples; window, fold and rotate input
   samples into FFT buffer; take FFT; and convert to
   amplitude-frequency (phase vocoder) form * /

	if ( D == 0 ) {
            if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		eof = 1;
	}
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    fconvert( buffer, channel, fltbuf, N2 );
	}
	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

/* overlap-add resynthesis */

	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s",
	"furious:  FFT based window filter processor\n",
	"furious   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	filter function filename\n");
    exit(woof);
}

