#include <stdio.h>
#include "pv.h"

extern float ithres;
extern int invert;

void tainter( S1, S2, C1, C2, N2, mult )
float *S1, *S2, *C1, *C2;
double mult;
int N2;
{
  int 		real, imag,
		amp,
		phase;
  float 	magn,
		a1,a2,
		b1,b2;
  int 		i;


    for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	a1 = ( i == N2 ? *(S1+1) : *(S1+real) ) ;
	b1 = ( i == 0 || i == N2 ? 0. : *(S1+imag) ) ;
	a2 = ( i == N2 ? S2[1] : S2[real] ) ;
	b2 = ( i == 0 || i == N2 ? 0. : *(S2+imag) ) ;
	*(C1+amp) = hypot( a1, b1 );
	*(C1+phase) = -atan2( b1, a1 );
	*(C2+amp) = hypot( a2, b2 );
	*(C2+phase) = -atan2( b2, a2 );
    }

    if (invert) {
      for ( i=0; i <= N2; i++ ) {
	amp = i<<1;
	magn = *(C2+amp);

	if ( magn > ithres )
	  magn *= ( (1. / magn) * mult );
	else
	  magn = 0.;
/* fprintf(stderr,"%f %f %f ", magn, mult, *(C1+amp)); */
        *(C1+amp) *= magn * mult;
/* fprintf(stderr,"%f\n", *(C1+amp)); */
      }
    }
    else {
      for ( i=0; i <= N2; i++ ) {
	amp = i<<1;
	magn = *(C2+amp);
        *(C1+amp) *= (*(C2+amp) * mult);
      }
    }

    for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	*(S1+real) = *(C1+amp) * cos( *(C1+phase) );
	if ( i != N2 ) 
	    *(S1+imag) = -*(C1+amp) * sin( *(C1+phase) );
    }
}
