#include <stdlib.h>
#include <stdio.h>
#include "crack.h"
#include "fury.h"

#define Max_Table_Size 262144

float PI;
float TWOPI;
float synt = 0.;
Tabl *sbuf;

main(argc, argv)
int argc; char *argv[];
{
    int 	i,
      		R,
		N,
		N2,
		Nw = 0,
		D = 0, 
		I = 0,
		in,
		on,
    		telms,
		its = 1,
		eof = 0;
    float 	pink = 1.,
		len = 0.,
    		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*channel,
		*output,
		*fltbuf;
    char	ch,
		file1[256],
		file2[256],
		*dbuf;
    FILE	*fp;

    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|i|f|F|n|l|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'i':	pink = atof(arg_option);
			break;
	    case 'f':	strcpy(file1, arg_option);
			break;
	    case 'F':	strcpy(file2, arg_option);
			break;
	    case 'n':	its = atoi(arg_option);
			break;
	    case 'l':	len = atof(arg_option);
	      		break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    fltbuf = (float *) space( (N / 2) + 1, sizeof(float) );
    sbuf = (Tabl *) space ( 1, sizeof(Tabl) );
    sbuf->data = (float *) space( Max_Table_Size, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    if ( (fp = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if (fread(fltbuf, sizeof(float), N2, fp) == 0) {
	fprintf(stderr,"where is the rest?\n");
 	exit(-1);
    }

    if ( (fp = fopen( file2, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file2);
	exit(-1);
    }

    while ( (fread(sbuf->data+i, sizeof(float), 1, fp)) != 0 && 
	   i < Max_Table_Size )
      ++i;
    sbuf->elms = i;

    if (len != 0. && pink == 1.)
      pink = ( ((float) sbuf->elms) / (( (float) R/D ) * len) ) * its;

    while ( !eof ) {

	in += D;
	on += I;

	if ( D == 0 ) {
            if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		eof = 1;
	}
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    sweeper( buffer, channel, fltbuf, N2, pink );
	}
	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    exit(0);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"fury:  sweeping window filter processor\n",
	"fury   [flags] < floatsams > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	i:	table position increment\n",
	"	f:	filter function filename\n",
	"	F:	sweep function filename\n",
	"	n:	number of sweep iterations\n",
	"	l:	length of input\n",
	"	h:	this cheery place\n");
    exit(woof);
}

