#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;

extern char *arg_option ;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 4096,
		Nw2, 
		D = 1024, 
		I = 1024,
		hoop,	
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0;
    float 	P = 0.,
		len,
		tincr,
		tpos,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output;
    char	ch,
		*dbuf;
float threshgen = .005;
float getthresh();
int Qflag ;
int i,j, Nplus2;

float attenfac = 1.0, clonegain = 1.0 ;
int binskip = 0;
int binoffset = 0;
int curbin ;
int num_of_bins = 31 ;
float *model ;
    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|q|t|s|h|a|o|n|S|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
			break;
	    case 't':	synt = atof(arg_option);
			break;
	    case 'q':	Qflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'a':	attenfac = atof(arg_option);
			break;
	    case 'o':	binoffset = atoi(arg_option);
			break;
	    case 'n':	num_of_bins = atoi(arg_option);
			break;
	    case 'S':	binskip = atoi(arg_option);
			break;
	}
    }
if( P )
   fprintf(stderr,"USING OSCILLATOR BANK RESYNTHESIS\n");

    if (Nw == 0)
	Nw = N;

	if (I == 0)
	    I = D;

    if (sflag)
      D = 0;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
    Nplus2 = N+2;
    fvec( Wanal, Nw ) ;	
    fvec( Wsyn, Nw ) ;
    fvec( input, Nw ) ;
    fvec( Hwin, Nw ) ;	
    fvec( buffer, N ) ;	
    fvec( channel, N+2 ) ;
    fvec( output, Nw ) ;
    fvec( model, num_of_bins );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {

	in += D;
	on += I;
	if ( D == 0 ) {
	  for ( hoop=0; hoop < Nplus2; hoop++ ) {
	    if ( fread(channel+hoop,sizeof(float),1,stdin) <= 0 )
	      eof = 1;
	  } 
	} 
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    if(Qflag)
	       convert( buffer, channel, N2, D, R );
	    else
	       leanconvert( buffer, channel, N2, D, R );
	}
// INSERT CLONES 
   curbin = binoffset * 2;
   for( i = 0 ; i < num_of_bins; i++, curbin += (binskip==0) ? 2 : (binskip*2)){
      while( curbin >= Nplus2 )
        curbin -= Nplus2 ;
      if( curbin == 0 ) curbin = 2;
      model[i] = channel[curbin];

   } 
   curbin = 0; i = 2;
   clonegain = 1.0;
   while( i < Nplus2 ){
      channel[i] = (clonegain == 1.0 ) ? model[curbin] : model[curbin]*clonegain;
      i += 2; 
      curbin++;
      if( curbin == num_of_bins ){
         curbin = 0;
	 if (attenfac != 1.0) 
	 clonegain *= attenfac; 
      }
   }
	if ( obank ) {
	    synt = getthresh( channel, N, threshgen );
	    noscbank( channel, N2, R, Nw, I, P, output );
	    shiftout( output, Nw, I, on+Nw-I );
	} 

	else {
	    if(Qflag)
	       unconvert( channel, buffer, N2, I, R );
	    else
	       leanunconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
	}
    }
    fprintf(stderr,"SCLONE: RESYNTHESIS COMPLETED\n");
    exit(0);
}
usage(meow)
{
    fprintf(stderr, "%s",
	"sclone:  spectral cloner\n"
	"sclone   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	D:	decimation factor in samples [1024]\n"
	"	I:	interpolation factor in samples [1024]\n"
	"	a:	clone attenuation factor [1.]\n"
	"	o:	bin offset  [0]\n"
	"	n:	number of bins to clone [31]\n"
	"	S:	bin skip [0]\n"
	"	P:	pitch factor [0.]\n"
	"	t:	threshold generator [.005]\n"
	"	q:	maintain phase coherence\n"
	"	s:	synthesize analysis input\n"
	);
    exit(meow);
}

